package com.zurrtum.create.content.logistics.vault;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.api.packager.InventoryIdentifier;
import com.zurrtum.create.foundation.block.NeighborChangeListeningBlock;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.VersionedInventory;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.ItemInventory;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import java.util.BitSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_4076;

public class ItemVaultBlockEntity extends SmartBlockEntity implements IMultiBlockEntityContainer.Inventory {

    protected Supplier<ItemInventory> itemCapability = null;
    protected InventoryIdentifier invId;

    protected ItemVaultHandler inventory;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius;
    protected int length;
    protected class_2351 axis;

    public ItemVaultBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ITEM_VAULT, pos, state);

        inventory = new ItemVaultHandler();

        radius = 1;
        length = 1;
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1264.method_5451(field_11863, pos, inventory);
        field_11863.method_8544(pos);
        ConnectivityHandler.splitMulti(this);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    protected void updateConnectivity() {
        updateConnectivity = false;
        if (field_11863.method_8608())
            return;
        if (!isController())
            return;
        ConnectivityHandler.formMulti(this);
    }

    protected void updateComparators() {
        ItemVaultBlockEntity controllerBE = getControllerBE();
        if (controllerBE == null)
            return;

        field_11863.method_8524(controllerBE.field_11867);

        class_2338 pos = controllerBE.method_11016();

        int radius = controllerBE.radius;
        int length = controllerBE.length;

        class_2351 axis = controllerBE.getMainConnectionAxis();

        int zMax = (axis == class_2351.field_11048 ? radius : length);
        int xMax = (axis == class_2351.field_11051 ? radius : length);

        // Mutable position we'll use for the blocks we poke updates at.
        class_2338.class_2339 updatePos = new class_2338.class_2339();
        // Mutable position we'll set to be the vault block next to the update position.
        class_2338.class_2339 provokingPos = new class_2338.class_2339();

        for (int y = 0; y < radius; y++) {
            for (int z = 0; z < zMax; z++) {
                for (int x = 0; x < xMax; x++) {
                    // Emulate the effect of this line, but only for blocks along the surface of the vault:
                    // level.updateNeighbourForOutputSignal(pos.offset(x, y, z), getBlockState().getBlock());
                    // That method pokes all 6 directions in order. We want to preserve the update order
                    // but skip the wasted work of checking other blocks that are part of this vault.

                    var sectionX = class_4076.method_18675(pos.method_10263() + x);
                    var sectionZ = class_4076.method_18675(pos.method_10260() + z);
                    if (!field_11863.method_8393(sectionX, sectionZ)) {
                        continue;
                    }
                    provokingPos.method_25504(pos, x, y, z);

                    // Technically all this work is wasted for the inner blocks of a long 3x3 vault, but
                    // this is fast enough and relatively simple.
                    class_2248 provokingBlock = field_11863.method_8320(provokingPos).method_26204();

                    // The 6 calls below should match the order of Direction.values().
                    if (y == 0) {
                        updateComparatorsInner(field_11863, provokingBlock, provokingPos, updatePos, class_2350.field_11033);
                    }
                    if (y == radius - 1) {
                        updateComparatorsInner(field_11863, provokingBlock, provokingPos, updatePos, class_2350.field_11036);
                    }
                    if (z == 0) {
                        updateComparatorsInner(field_11863, provokingBlock, provokingPos, updatePos, class_2350.field_11043);
                    }
                    if (z == zMax - 1) {
                        updateComparatorsInner(field_11863, provokingBlock, provokingPos, updatePos, class_2350.field_11035);
                    }
                    if (x == 0) {
                        updateComparatorsInner(field_11863, provokingBlock, provokingPos, updatePos, class_2350.field_11039);
                    }
                    if (x == xMax - 1) {
                        updateComparatorsInner(field_11863, provokingBlock, provokingPos, updatePos, class_2350.field_11034);
                    }
                }
            }
        }
    }

    /**
     * See {@link class_1937#method_8455(class_2338, class_2248)}.
     */
    private static void updateComparatorsInner(
        class_1937 level,
        class_2248 provokingBlock,
        class_2338 provokingPos,
        class_2338.class_2339 updatePos,
        class_2350 direction
    ) {
        updatePos.method_25505(provokingPos, direction);

        var sectionX = class_4076.method_18675(updatePos.method_10263());
        var sectionZ = class_4076.method_18675(updatePos.method_10260());
        if (!level.method_8393(sectionX, sectionZ)) {
            return;
        }

        class_2680 blockstate = level.method_8320(updatePos);
        if (blockstate.method_26204() instanceof NeighborChangeListeningBlock block) {
            block.onNeighborChange(blockstate, level, updatePos, provokingPos);
        }

        if (blockstate.method_27852(class_2246.field_10377)) {
            level.method_41410(blockstate, updatePos, provokingBlock, null, false);
        } else if (blockstate.method_26212(level, updatePos)) {
            updatePos.method_10098(direction);
            blockstate = level.method_8320(updatePos);
            if (blockstate.method_27852(class_2246.field_10377)) {
                level.method_41410(blockstate, updatePos, provokingBlock, null, false);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();

        if (lastKnownPos == null)
            lastKnownPos = method_11016();
        else if (!lastKnownPos.equals(field_11867) && field_11867 != null) {
            onPositionChanged();
            return;
        }

        if (updateConnectivity)
            updateConnectivity();
    }

    @Override
    public class_2338 getLastKnownPos() {
        return lastKnownPos;
    }

    @Override
    public boolean isController() {
        return controller == null || field_11867.method_10263() == controller.method_10263() && field_11867.method_10264() == controller.method_10264() && field_11867.method_10260() == controller.method_10260();
    }

    private void onPositionChanged() {
        removeController(true);
        lastKnownPos = field_11867;
    }

    @SuppressWarnings("unchecked")
    @Override
    public ItemVaultBlockEntity getControllerBE() {
        if (isController())
            return this;
        class_2586 blockEntity = field_11863.method_8321(controller);
        if (blockEntity instanceof ItemVaultBlockEntity)
            return (ItemVaultBlockEntity) blockEntity;
        return null;
    }

    public void removeController(boolean keepContents) {
        if (field_11863.method_8608())
            return;
        updateConnectivity = true;
        controller = null;
        radius = 1;
        length = 1;

        class_2680 state = method_11010();
        if (ItemVaultBlock.isVault(state)) {
            state = state.method_11657(ItemVaultBlock.LARGE, false);
            method_10997().method_8652(field_11867, state, class_2248.field_31028 | class_2248.field_31029 | class_2248.field_31031);
        }

        itemCapability = null;
        method_5431();
        sendData();
    }

    @Override
    public void setController(class_2338 controller) {
        if (field_11863.field_9236 && !isVirtual())
            return;
        if (controller.equals(this.controller))
            return;
        this.controller = controller;
        itemCapability = null;
        method_5431();
        sendData();
    }

    @Override
    public class_2338 getController() {
        return isController() ? field_11867 : controller;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        class_2338 controllerBefore = controller;
        int prevSize = radius;
        int prevLength = length;

        updateConnectivity = view.method_71433("Uninitialized", false);

        lastKnownPos = view.method_71426("LastKnownPos", class_2338.field_25064).orElse(null);

        controller = view.method_71426("Controller", class_2338.field_25064).orElse(null);

        if (isController()) {
            radius = view.method_71424("Size", 0);
            length = view.method_71424("Length", 0);
        }

        if (!clientPacket) {
            inventory.read(view);
            return;
        }

        boolean changeOfController = controllerBefore == null ? controller != null : !controllerBefore.equals(controller);
        if (method_11002() && (changeOfController || prevSize != radius || prevLength != length))
            field_11863.method_16109(method_11016(), class_2246.field_10124.method_9564(), method_11010());
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        if (updateConnectivity)
            view.method_71472("Uninitialized", true);

        if (lastKnownPos != null)
            view.method_71468("LastKnownPos", class_2338.field_25064, lastKnownPos);
        if (isController()) {
            view.method_71465("Size", radius);
            view.method_71465("Length", length);
        } else {
            view.method_71468("Controller", class_2338.field_25064, controller);
        }

        super.write(view, clientPacket);

        if (!clientPacket) {
            view.method_71469("StorageType", "CombinedInv");
            inventory.write(view);
        }
    }

    public ItemVaultHandler getInventoryOfBlock() {
        return inventory;
    }

    public InventoryIdentifier getInvId() {
        // ensure capability is up to date first, which sets the ID
        this.initCapability();
        return this.invId;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        int size = handler.method_5439();
        for (int i = 0; i < size; i++) {
            inventory.method_5447(i, handler.method_5438(i));
        }
        for (int i = size, max = inventory.method_5439(); i < max; i++) {
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    public void initCapability() {
        if (!isController()) {
            ItemVaultBlockEntity controllerBE = getControllerBE();
            if (controllerBE == null)
                return;
            if (controllerBE.itemCapability == null || controllerBE.itemCapability.get() == null)
                controllerBE.initCapability();
            itemCapability = () -> {
                if (controllerBE.method_11015())
                    return null;
                if (controllerBE.itemCapability == null)
                    return null;
                return controllerBE.itemCapability.get();
            };
            invId = controllerBE.invId;
            return;
        }

        boolean alongZ = ItemVaultBlock.getVaultBlockAxis(method_11010()) == class_2351.field_11051;
        ItemVaultHandler[] invs = new ItemVaultHandler[length * radius * radius];
        Find:
        for (int yOffset = 0; yOffset < length; yOffset++) {
            for (int xOffset = 0; xOffset < radius; xOffset++) {
                for (int zOffset = 0; zOffset < radius; zOffset++) {
                    class_2338 vaultPos = alongZ ? field_11867.method_10069(xOffset, zOffset, yOffset) : field_11867.method_10069(yOffset, xOffset, zOffset);
                    ItemVaultBlockEntity vaultAt = ConnectivityHandler.partAt(AllBlockEntityTypes.ITEM_VAULT, field_11863, vaultPos);
                    if (vaultAt == null) {
                        invs = null;
                        break Find;
                    }
                    invs[yOffset * radius * radius + xOffset * radius + zOffset] = vaultAt.inventory;
                }
            }
        }

        if (invs == null) {
            itemCapability = null;
        } else {
            ConnectedItemVaultHandler capability = new ConnectedItemVaultHandler(invs);
            itemCapability = () -> capability;
        }

        // build an identifier encompassing all component vaults
        class_2338 farCorner = alongZ ? field_11867.method_10069(radius, radius, length) : field_11867.method_10069(length, radius, radius);
        class_3341 bounds = class_3341.method_34390(this.field_11867, farCorner);
        this.invId = new InventoryIdentifier.Bounds(bounds);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    @Override
    public void preventConnectivityUpdate() {
        updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (ItemVaultBlock.isVault(state)) { // safety
            field_11863.method_8652(method_11016(), state.method_11657(ItemVaultBlock.LARGE, radius > 2), class_2248.field_31028 | class_2248.field_31029);
        }
        itemCapability = null;
        method_5431();
    }

    @Override
    public class_2350.class_2351 getMainConnectionAxis() {
        return getMainAxisOf(this);
    }

    @Override
    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052)
            return getMaxWidth();
        return getMaxLength(width);
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return length;
    }

    @Override
    public int getWidth() {
        return radius;
    }

    @Override
    public void setHeight(int height) {
        this.length = height;
    }

    @Override
    public void setWidth(int width) {
        this.radius = width;
    }

    @Override
    public boolean hasInventory() {
        return true;
    }

    public class ItemVaultHandler implements ItemInventory {
        private final int size;
        protected final class_2371<class_1799> stacks;

        public ItemVaultHandler() {
            size = AllConfigs.server().logistics.vaultCapacity.get();
            stacks = class_2371.method_10213(size, class_1799.field_8037);
        }

        @Override
        public int method_5439() {
            return size;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot >= size) {
                return class_1799.field_8037;
            }
            return stacks.get(slot);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            if (slot >= size) {
                return;
            }
            stacks.set(slot, stack);
        }

        @Override
        public void method_5431() {
            field_11863.method_8524(field_11867);
        }

        public void write(class_11372 view) {
            class_11372.class_11373<class_1799> list = view.method_71467("Inventory", class_1799.field_24671);
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) {
                    continue;
                }
                list.method_71484(stack);
            }
        }

        public void read(class_11368 view) {
            class_11368.class_11369<class_1799> list = view.method_71437("Inventory", class_1799.field_24671);
            int i = 0;
            for (class_1799 itemStack : list) {
                stacks.set(i++, itemStack);
            }
            for (int size = stacks.size(); i < size; i++) {
                stacks.set(i, class_1799.field_8037);
            }
        }
    }

    public class ConnectedItemVaultHandler implements ItemInventory, VersionedInventory {
        private final ItemVaultHandler[] itemHandler;
        private final int vaultCapacity;
        private final int size;
        private final int id;
        private final BitSet accessed;
        private int version;

        public ConnectedItemVaultHandler(ItemVaultHandler[] invs) {
            vaultCapacity = AllConfigs.server().logistics.vaultCapacity.get();
            itemHandler = invs;
            size = vaultCapacity * invs.length;
            id = idGenerator.getAndIncrement();
            accessed = new BitSet(invs.length);
            version = 0;
        }

        @Override
        public int method_5439() {
            return size;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot >= size) {
                return class_1799.field_8037;
            }
            int i = slot / vaultCapacity;
            accessed.set(i);
            return itemHandler[i].method_5438(slot % vaultCapacity);
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            if (slot >= size) {
                return;
            }
            int i = slot / vaultCapacity;
            ItemVaultHandler handler = itemHandler[i];
            handler.method_5447(slot % vaultCapacity, stack);
            handler.method_5431();
        }

        @Override
        public int insert(class_1799 stack) {
            if (stack.method_7960()) {
                return 0;
            }
            int maxAmount = stack.method_7947();
            int remaining = maxAmount;
            for (ItemVaultHandler handler : itemHandler) {
                int insert = handler.insert(stack);
                if (remaining == insert) {
                    incrementVersion();
                    stack.method_7939(maxAmount);
                    return maxAmount;
                }
                if (insert == 0) {
                    continue;
                }
                stack.method_7939(remaining -= insert);
            }
            if (remaining == maxAmount) {
                return 0;
            }
            incrementVersion();
            stack.method_7939(maxAmount);
            return maxAmount - remaining;
        }

        @Override
        public int extract(class_1799 stack) {
            if (stack.method_7960()) {
                return 0;
            }
            int maxAmount = stack.method_7947();
            int remaining = maxAmount;
            for (ItemVaultHandler handler : itemHandler) {
                int extract = handler.extract(stack);
                if (remaining == extract) {
                    incrementVersion();
                    stack.method_7939(maxAmount);
                    return maxAmount;
                }
                if (extract == 0) {
                    continue;
                }
                stack.method_7939(remaining -= extract);
            }
            if (remaining == maxAmount) {
                return 0;
            }
            incrementVersion();
            stack.method_7939(maxAmount);
            return maxAmount - remaining;
        }

        @Override
        public class_1799 extract(Predicate<class_1799> predicate, int maxAmount) {
            if (maxAmount == 0) {
                return class_1799.field_8037;
            }
            for (int i = 0, size = itemHandler.length; i < size; i++) {
                class_1799 findStack = itemHandler[i].extract(predicate, maxAmount);
                if (findStack == class_1799.field_8037) {
                    continue;
                }
                int extract = findStack.method_7947();
                if (extract == maxAmount) {
                    incrementVersion();
                    return findStack;
                }
                i++;
                if (i == size) {
                    incrementVersion();
                    return findStack;
                }
                int remaining = maxAmount - extract;
                for (; i < size; i++) {
                    extract = itemHandler[i].extract(findStack);
                    if (remaining == extract) {
                        incrementVersion();
                        findStack.method_7939(maxAmount);
                        return findStack;
                    }
                    if (extract == 0) {
                        continue;
                    }
                    findStack.method_7939(remaining -= extract);
                }
                incrementVersion();
                findStack.method_7939(maxAmount - remaining);
                return findStack;
            }
            return class_1799.field_8037;
        }

        @Override
        public class_1799 preciseExtract(Predicate<class_1799> predicate, int maxAmount) {
            if (maxAmount == 0) {
                return class_1799.field_8037;
            }
            for (int i = 0, size = itemHandler.length; i < size; i++) {
                class_1799 findStack = itemHandler[i].count(predicate, maxAmount);
                if (findStack.method_7960()) {
                    continue;
                }
                int count = findStack.method_7947();
                if (count == maxAmount) {
                    itemHandler[i].extract(findStack);
                    incrementVersion();
                    return findStack;
                }
                i++;
                if (i == size) {
                    break;
                }
                int[] extracts = new int[size];
                int remaining = maxAmount - count;
                for (; i < size; i++) {
                    int extract = itemHandler[i].count(findStack, remaining);
                    if (extract == 0) {
                        continue;
                    }
                    extracts[i] = extract;
                    if (remaining > extract) {
                        remaining -= extract;
                        continue;
                    }
                    itemHandler[0].extract(findStack);
                    for (int j = 1; j <= i; j++) {
                        extract = extracts[j];
                        if (extract == 0) {
                            continue;
                        }
                        findStack.method_7939(extract);
                        itemHandler[j].extract(findStack);
                    }
                    incrementVersion();
                    findStack.method_7939(maxAmount);
                    return findStack;
                }
            }
            return class_1799.field_8037;
        }

        public int getVersion() {
            return version;
        }

        public int getId() {
            return id;
        }

        @Override
        public void method_5431() {
            for (ItemVaultHandler inventory : itemHandler) {
                inventory.method_5431();
            }
            incrementVersion();
        }

        private void incrementVersion() {
            updateComparators();
            version++;
        }
    }
}
