package com.zurrtum.create.content.processing.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_5819;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record ChanceOutput(float chance, class_1799 stack) {
    public static Codec<ChanceOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.FLOAT.optionalFieldOf("chance", 1F)
            .forGetter(ChanceOutput::chance), class_1799.field_55709.forGetter(ChanceOutput::stack)
    ).apply(instance, ChanceOutput::new));
    public static class_9139<class_9129, ChanceOutput> PACKET_CODEC = class_9139.method_56435(
        class_9135.field_48552,
        ChanceOutput::chance,
        class_1799.field_48349,
        ChanceOutput::stack,
        ChanceOutput::new
    );

    @Nullable
    public class_1799 get(class_5819 random) {
        if (chance == 1) {
            return stack.method_7972();
        }
        int count = stack.method_7947();
        for (int i = 0, n = count; i < n; i++) {
            if (random.method_43057() > chance) {
                count--;
            }
        }
        if (count == 0) {
            return null;
        }
        return stack.method_46651(count);
    }
}
