package com.zurrtum.create.content.redstone.analogLever;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.foundation.block.IBE;
import org.jetbrains.annotations.NotNull;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5819;

public class AnalogLeverBlock extends class_2341 implements IBE<AnalogLeverBlockEntity> {

    public static final MapCodec<AnalogLeverBlock> field_46280 = method_54094(AnalogLeverBlock::new);
    private final Function<class_2680, class_265> shapeFunction;

    public AnalogLeverBlock(class_2251 p_i48402_1_) {
        super(p_i48402_1_);
        this.shapeFunction = this.createShapeFunction();
    }

    private Function<class_2680, class_265> createShapeFunction() {
        Map<class_2738, Map<class_2350, class_265>> map = class_259.method_66506(class_2248.method_66405(
            6.0,
            8.0,
            10.0,
            16.0
        ));
        return this.method_33615(state -> map.get(state.method_11654(field_11007)).get(state.method_11654(field_11177)));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return shapeFunction.apply(state);
    }

    public static boolean onBlockActivated(class_1268 hand, class_2680 state, class_1799 stack) {
        if (hand == class_1268.field_5810 || stack.method_31574(AllItems.WRENCH)) {
            return false;
        }
        return state.method_26204() instanceof AnalogLeverBlock;
    }

    @Override
    public class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 worldIn,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (worldIn.field_9236) {
            addParticles(state, worldIn, pos, 1.0F);
            return class_1269.field_5812;
        }

        return onBlockEntityUse(
            worldIn, pos, be -> {
                boolean sneak = player.method_5715();
                be.changeState(sneak);
                float f = .25f + ((be.state + 5) / 15f) * .5f;
                worldIn.method_8396(null, pos, class_3417.field_14962, class_3419.field_15245, 0.2F, f);
                return class_1269.field_5812;
            }
        );
    }

    @Override
    public int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        return getBlockEntityOptional(blockAccess, pos).map(al -> al.state).orElse(0);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    public int method_9603(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        return method_10119(blockState) == side ? method_9524(blockState, blockAccess, pos, side) : 0;
    }

    @Override
    public void method_9496(class_2680 stateIn, class_1937 worldIn, class_2338 pos, class_5819 rand) {
        withBlockEntityDo(
            worldIn, pos, be -> {
                if (be.state != 0 && rand.method_43057() < 0.25F)
                    addParticles(stateIn, worldIn, pos, 0.5F);
            }
        );
    }

    @Override
    public void method_66388(class_2680 state, class_3218 worldIn, class_2338 pos, boolean isMoving) {
        if (isMoving)
            return;
        withBlockEntityDo(
            worldIn, pos, be -> {
                if (be.state != 0)
                    updateNeighbors(state, worldIn, pos);
                worldIn.method_8544(pos);
            }
        );
    }

    private static void addParticles(class_2680 state, class_1936 worldIn, class_2338 pos, float alpha) {
        class_2350 direction = state.method_11654(field_11177).method_10153();
        class_2350 direction1 = method_10119(state).method_10153();
        double d0 = (double) pos.method_10263() + 0.5D + 0.1D * (double) direction.method_10148() + 0.2D * (double) direction1.method_10148();
        double d1 = (double) pos.method_10264() + 0.5D + 0.1D * (double) direction.method_10164() + 0.2D * (double) direction1.method_10164();
        double d2 = (double) pos.method_10260() + 0.5D + 0.1D * (double) direction.method_10165() + 0.2D * (double) direction1.method_10165();
        worldIn.method_8406(new class_2390(0xFF0000, alpha), d0, d1, d2, 0.0D, 0.0D, 0.0D);
    }

    static void updateNeighbors(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8452(pos, state.method_26204(), null);
        world.method_8452(pos.method_10093(method_10119(state).method_10153()), state.method_26204(), null);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(field_11177, field_11007));
    }

    @Override
    public Class<AnalogLeverBlockEntity> getBlockEntityClass() {
        return AnalogLeverBlockEntity.class;
    }

    @Override
    public class_2591<? extends AnalogLeverBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ANALOG_LEVER;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2341> method_53969() {
        return field_46280;
    }
}
