package com.zurrtum.create.content.redstone.diodes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.foundation.block.RedStoneConnectBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class ToggleLatchBlock extends AbstractDiodeBlock implements RedStoneConnectBlock {

    public static class_2746 POWERING = class_2746.method_11825("powering");

    public static final MapCodec<ToggleLatchBlock> field_46280 = method_54094(ToggleLatchBlock::new);

    public ToggleLatchBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(POWERING, false).method_11657(field_10911, false));
    }

    @Override
    protected @NotNull MapCodec<? extends class_2312> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_10911, POWERING, field_11177);
    }

    @Override
    public int method_9524(class_2680 blockState, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        return blockState.method_11654(field_11177) == side ? method_9993(blockAccess, pos, blockState) : 0;
    }

    @Override
    protected int method_9992(class_2680 state) {
        return 1;
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!player.method_7294())
            return class_1269.field_52423;
        if (player.method_5715())
            return class_1269.field_52423;
        if (stack.method_31574(AllItems.WRENCH))
            return class_1269.field_52423;
        return activated(level, pos, state);
    }

    @Override
    protected int method_9993(class_1922 worldIn, class_2338 pos, class_2680 state) {
        return state.method_11654(POWERING) ? 15 : 0;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        boolean poweredPreviously = state.method_11654(field_10911);
        super.method_9588(state, worldIn, pos, random);
        class_2680 newState = worldIn.method_8320(pos);
        if (newState.method_11654(field_10911) && !poweredPreviously)
            worldIn.method_8652(pos, newState.method_28493(POWERING), class_2248.field_31028);
    }

    protected class_1269 activated(class_1937 worldIn, class_2338 pos, class_2680 state) {
        if (!worldIn.field_9236) {
            float f = !state.method_11654(POWERING) ? 0.6F : 0.5F;
            worldIn.method_8396(null, pos, class_3417.field_14962, class_3419.field_15245, 0.3F, f);
            worldIn.method_8652(pos, state.method_28493(POWERING), class_2248.field_31028);
        }
        return class_1269.field_5812;
    }

    @Override
    public boolean canConnectRedstone(class_2680 state, class_2350 side) {
        if (side == null)
            return false;
        return side.method_10166() == state.method_11654(field_11177).method_10166();
    }

}
