package com.zurrtum.create.content.redstone.displayLink;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class LinkWithBulbBlockEntity extends SmartBlockEntity {

    private LerpedFloat glow;
    private boolean sendPulse;

    public LinkWithBulbBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        glow = LerpedFloat.linear().startWithValue(0);
        glow.chase(0, 0.5f, Chaser.EXP);
    }

    @Override
    public void tick() {
        super.tick();
        if (isVirtual() || field_11863.method_8608())
            glow.tickChaser();
    }

    public float getGlow(float partialTicks) {
        return glow.getValue(partialTicks);
    }

    public void sendPulseNextSync() {
        sendPulse = true;
    }

    public void pulse() {
        glow.setValue(2);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        if (clientPacket && sendPulse) {
            sendPulse = false;
            view.method_71472("Pulse", true);
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket && view.method_71433("Pulse", false))
            pulse();
    }

    public class_243 getBulbOffset(class_2680 state) {
        return class_243.field_1353;
    }

    public class_2350 getBulbFacing(class_2680 state) {
        return state.method_11654(DisplayLinkBlock.field_10927);
    }

}
