package com.zurrtum.create.content.redstone.nixieTube;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity.SignalState;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8824;

public class NixieTubeBlockEntity extends SmartBlockEntity {

    private static final Couple<String> EMPTY = Couple.create("", "");

    private int redstoneStrength;
    private Optional<class_2561> customText;
    private int nixieIndex;
    private Couple<String> displayedStrings;
    private boolean keepAlive;

    private WeakReference<SignalBlockEntity> cachedSignalTE;
    public SignalState signalState;

    public NixieTubeBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.NIXIE_TUBE, pos, state);
        customText = Optional.empty();
        redstoneStrength = 0;
        cachedSignalTE = new WeakReference<>(null);
    }

    @Override
    public void tick() {
        super.tick();
        if (!field_11863.field_9236)
            return;
        signalState = null;
        SignalBlockEntity signalBlockEntity = cachedSignalTE.get();

        if (signalBlockEntity == null || signalBlockEntity.method_11015()) {
            class_2350 facing = NixieTubeBlock.getFacing(method_11010());
            class_2586 blockEntity = field_11863.method_8321(field_11867.method_10093(facing.method_10153()));
            if (blockEntity instanceof SignalBlockEntity signal) {
                signalState = signal.getState();
                cachedSignalTE = new WeakReference<>(signal);
            }
            return;
        }

        signalState = signalBlockEntity.getState();
    }

    @Override
    public void initialize() {
        if (field_11863.field_9236)
            updateDisplayedStrings();
    }

    //

    public boolean reactsToRedstone() {
        return customText.isEmpty();
    }

    public Couple<String> getDisplayedStrings() {
        if (displayedStrings == null)
            return EMPTY;
        return displayedStrings;
    }

    public class_5250 getFullText() {
        return customText.map(class_2561::method_27661).orElse(class_2561.method_43470("" + redstoneStrength));
    }

    public void updateRedstoneStrength(int signalStrength) {
        clearCustomText();
        redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
        notifyUpdate();
    }

    public void displayCustomText(class_2561 text, int nixiePositionInRow) {
        if (text == null)
            return;
        if (customText.filter(d -> d.equals(text)).isPresent())
            return;

        customText = Optional.ofNullable(DynamicComponent.parseCustomText(field_11863, field_11867, text));
        nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers(field_11863, field_11867);
        notifyUpdate();
    }

    public void displayEmptyText(int nixiePositionInRow) {
        displayCustomText(class_5244.field_39003, nixiePositionInRow);
    }

    public void updateDisplayedStrings() {
        if (signalState != null)
            return;
        customText.map(class_2561::getString).ifPresentOrElse(
            fullText -> displayedStrings = Couple.create(charOrEmpty(fullText, nixieIndex * 2), charOrEmpty(fullText, nixieIndex * 2 + 1)),
            () -> displayedStrings = Couple.create(redstoneStrength < 10 ? "0" : "1", String.valueOf(redstoneStrength % 10))
        );
    }

    public void clearCustomText() {
        nixieIndex = 0;
        customText = Optional.empty();
    }

    public int getRedstoneStrength() {
        return redstoneStrength;
    }

    //

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        view.method_71426("CustomText", class_8824.field_46597).ifPresentOrElse(
            text -> {
                customText = Optional.of(text);
                nixieIndex = view.method_71424("CustomTextIndex", 0);
            }, () -> redstoneStrength = view.method_71424("RedstoneStrength", 0)
        );
        if (clientPacket || isVirtual())
            updateDisplayedStrings();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);

        customText.ifPresentOrElse(
            text -> {
                view.method_71465("CustomTextIndex", nixieIndex);
                view.method_71468("CustomText", class_8824.field_46597, text);
            }, () -> view.method_71465("RedstoneStrength", redstoneStrength)
        );
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_2680 state = field_11863.method_8320(pos);
        if (method_11017().method_20526(state)) {
            keepAlive = true;
            method_31664(state);
        } else {
            super.method_66473(pos, oldState);
        }
    }

    @Override
    public void method_11012() {
        if (keepAlive) {
            keepAlive = false;
            field_11863.method_22350(field_11867).method_12007(this);
        } else {
            super.method_11012();
        }
    }
}
