package com.zurrtum.create.content.schematics;

import com.zurrtum.create.Create;
import com.zurrtum.create.foundation.utility.FilesHelper;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3341;
import net.minecraft.class_3499;

public class SchematicExport {
    /**
     * Save a schematic to a file from a world.
     *
     * @param dir       the directory the schematic will be created in
     * @param fileName  the ideal name of the schematic, may not be the name of the created file
     * @param overwrite whether overwriting an existing schematic is allowed
     * @param level     the level where the schematic structure is placed
     * @param first     the first corner of the schematic area
     * @param second    the second corner of the schematic area
     * @return a SchematicExportResult, or null if an error occurred.
     */
    @Nullable
    public static SchematicExportResult saveSchematic(Path dir, String fileName, boolean overwrite, class_1937 level, class_2338 first, class_2338 second) {
        class_3341 bb = class_3341.method_34390(first, second);
        class_2338 origin = new class_2338(bb.method_35415(), bb.method_35416(), bb.method_35417());
        class_2338 bounds = new class_2338(bb.method_35414(), bb.method_14660(), bb.method_14663());

        class_3499 structure = new class_3499();
        structure.method_15174(level, origin, bounds, true, List.of(class_2246.field_10124));
        class_2487 data = structure.method_15175(new class_2487());
        SchematicAndQuillItem.replaceStructureVoidWithAir(data);
        SchematicAndQuillItem.clampGlueBoxes(level, new class_238(class_243.method_24954(origin), class_243.method_24954(origin.method_10081(bounds))), data);

        if (fileName.isEmpty())
            fileName = class_2561.method_43471("create.schematicAndQuill.fallbackName").getString();
        if (!overwrite)
            fileName = FilesHelper.findFirstValidFilename(fileName, dir, "nbt");
        if (!fileName.endsWith(".nbt"))
            fileName += ".nbt";
        Path file = dir.resolve(fileName).toAbsolutePath();

        try {
            Files.createDirectories(dir);
            boolean overwritten = Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE)) {
                class_2507.method_10634(data, out);
            }
            return new SchematicExportResult(file, dir, fileName, overwritten, origin, bounds);
        } catch (IOException e) {
            Create.LOGGER.error("An error occurred while saving schematic [" + fileName + "]", e);
            return null;
        }
    }

    public record SchematicExportResult(
        Path file, Path dir, String fileName, boolean overwritten, class_2338 origin, class_2338 bounds
    ) {
    }
}
