package com.zurrtum.create.content.trains.graph;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class DimensionPalette implements Codec<class_5321<class_1937>> {
    public static final Codec<DimensionPalette> CODEC = class_5321.method_39154(class_7924.field_41223).listOf()
        .xmap(DimensionPalette::new, DimensionPalette::getGatheredDims);
    public static final class_9139<ByteBuf, DimensionPalette> PACKET_CODEC = class_5321.method_56038(class_7924.field_41223)
        .method_56433(class_9135.method_56363()).method_56432(DimensionPalette::new, DimensionPalette::getGatheredDims);

    private final List<class_5321<class_1937>> gatheredDims;

    public DimensionPalette() {
        gatheredDims = new ArrayList<>();
    }

    public DimensionPalette(List<class_5321<class_1937>> gatheredDims) {
        this.gatheredDims = gatheredDims;
    }

    private List<class_5321<class_1937>> getGatheredDims() {
        return gatheredDims;
    }

    public int encode(class_5321<class_1937> dimension) {
        int indexOf = gatheredDims.indexOf(dimension);
        if (indexOf == -1) {
            indexOf = gatheredDims.size();
            gatheredDims.add(dimension);
        }
        return indexOf;
    }

    public class_5321<class_1937> decode(int index) {
        if (gatheredDims.size() <= index || index < 0)
            return class_1937.field_25179;
        return gatheredDims.get(index);
    }

    @Override
    public <T> DataResult<Pair<class_5321<class_1937>, T>> decode(DynamicOps<T> ops, T input) {
        return Codec.INT.decode(ops, input).map(p -> p.mapFirst(this::decode));
    }

    @Override
    public <T> DataResult<T> encode(class_5321<class_1937> input, DynamicOps<T> ops, T prefix) {
        return Codec.INT.encode(encode(input), ops, prefix);
    }
}
