package com.zurrtum.create.content.trains.station;

import com.mojang.serialization.*;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.graph.TrackNode;
import com.zurrtum.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class GlobalStation extends SingleBlockEntityEdgePoint {
    public static final Codec<Map<class_2338, GlobalPackagePort>> PORTS_CODEC = CreateCodecs.getCodecMap(class_2338.field_25064, GlobalPackagePort.CODEC);

    public String name;
    public WeakReference<Train> nearestTrain;
    public boolean assembling;

    public Map<class_2338, GlobalPackagePort> connectedPorts;

    public GlobalStation() {
        name = "Track Station";
        nearestTrain = new WeakReference<>(null);
        connectedPorts = new HashMap<>();
    }

    @Override
    public void blockEntityAdded(class_2586 blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        class_2680 state = blockEntity.method_11010();
        assembling = state != null && state.method_28498(StationBlock.ASSEMBLING) && state.method_11654(StationBlock.ASSEMBLING);
    }

    @Override
    public void read(class_11368 view, boolean migration, DimensionPalette dimensions) {
        super.read(view, migration, dimensions);
        name = view.method_71428("Name", "");
        assembling = view.method_71433("Assembling", false);
        nearestTrain = new WeakReference<>(null);
        view.method_71426("Ports", PORTS_CODEC).ifPresentOrElse(ports -> connectedPorts = ports, connectedPorts::clear);
    }

    @Override
    public <T> void decode(DynamicOps<T> ops, T input, boolean migration, DimensionPalette dimensions) {
        super.decode(ops, input, migration, dimensions);
        MapLike<T> map = ops.getMap(input).getOrThrow();
        name = ops.getStringValue(map.get("Name")).result().orElse("");
        assembling = ops.getBooleanValue(map.get("Assembling")).getOrThrow();
    }

    @Override
    public void read(class_2540 buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        name = buffer.method_19772();
        assembling = buffer.readBoolean();
        if (buffer.readBoolean())
            blockEntityPos = buffer.method_10811();
    }

    @Override
    public void write(class_11372 view, DimensionPalette dimensions) {
        super.write(view, dimensions);
        view.method_71469("Name", name);
        view.method_71472("Assembling", assembling);
        view.method_71468("Ports", PORTS_CODEC, connectedPorts);
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        DataResult<T> prefix = super.encode(ops, empty, dimensions);
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("Name", ops.createString(name));
        map.add("Assembling", ops.createBoolean(assembling));
        map.add("Ports", connectedPorts, PORTS_CODEC);
        return map.build(prefix);
    }

    @Override
    public void write(class_2540 buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.method_10814(name);
        buffer.method_52964(assembling);
        buffer.method_52964(blockEntityPos != null);
        if (blockEntityPos != null)
            buffer.method_10807(blockEntityPos);
    }

    public boolean canApproachFrom(TrackNode side) {
        return isPrimary(side) && !assembling;
    }

    @Override
    public boolean canNavigateVia(TrackNode side) {
        return super.canNavigateVia(side) && !assembling;
    }

    public void reserveFor(Train train) {
        Train nearestTrain = getNearestTrain();
        if (nearestTrain == null || nearestTrain.navigation.distanceToDestination > train.navigation.distanceToDestination)
            this.nearestTrain = new WeakReference<>(train);
    }

    public void cancelReservation(Train train) {
        if (nearestTrain.get() == train)
            nearestTrain = new WeakReference<>(null);
    }

    public void trainDeparted(Train train) {
        cancelReservation(train);
    }

    @Nullable
    public Train getPresentTrain() {
        Train nearestTrain = getNearestTrain();
        if (nearestTrain == null || nearestTrain.getCurrentStation() != this)
            return null;
        return nearestTrain;
    }

    @Nullable
    public Train getImminentTrain() {
        Train nearestTrain = getNearestTrain();
        if (nearestTrain == null)
            return nearestTrain;
        if (nearestTrain.getCurrentStation() == this)
            return nearestTrain;
        if (!nearestTrain.navigation.isActive())
            return null;
        if (nearestTrain.navigation.distanceToDestination > 30)
            return null;
        return nearestTrain;
    }

    @Nullable
    public Train getNearestTrain() {
        return this.nearestTrain.get();
    }

    public void runMailTransfer() {
        Train train = getPresentTrain();
        if (train == null || connectedPorts.isEmpty())
            return;
        MinecraftServer server = Create.SERVER;
        class_1937 level = server.method_3847(getBlockEntityDimension());

        for (Carriage carriage : train.carriages) {
            class_1263 carriageInventory = carriage.storage.getAllItems();
            if (carriageInventory == null)
                continue;

            // Import from station
            for (Map.Entry<class_2338, GlobalPackagePort> entry : connectedPorts.entrySet()) {
                GlobalPackagePort port = entry.getValue();
                class_2338 pos = entry.getKey();
                PostboxBlockEntity box = null;

                class_1263 postboxInventory = port.offlineBuffer;
                if (level != null && level.method_8477(pos) && level.method_8321(pos) instanceof PostboxBlockEntity ppbe) {
                    postboxInventory = ppbe.inventory;
                    box = ppbe;
                }

                for (int slot = 0, size = postboxInventory.method_5439(); slot < size; slot++) {
                    class_1799 stack = postboxInventory.method_5438(slot);
                    if (PackageItem.matchAddress(stack, port.address))
                        continue;

                    int insert = carriageInventory.insert(stack);
                    if (insert == 0)
                        continue;

                    int count = stack.method_7947();
                    if (insert == count) {
                        postboxInventory.method_5447(slot, class_1799.field_8037);
                    } else {
                        stack.method_7939(count - insert);
                    }
                    if (box == null) {
                        port.primed = true;
                    } else {
                        box.spawnParticles();
                    }
                    Create.RAILWAYS.markTracksDirty();
                }
            }

            // Export to station
            for (class_1799 stack : carriageInventory) {
                if (!PackageItem.isPackage(stack))
                    continue;

                for (Map.Entry<class_2338, GlobalPackagePort> entry : connectedPorts.entrySet()) {
                    GlobalPackagePort port = entry.getValue();
                    class_2338 pos = entry.getKey();
                    PostboxBlockEntity box = null;

                    if (!PackageItem.matchAddress(stack, port.address))
                        continue;

                    class_1263 postboxInventory = port.offlineBuffer;
                    if (level != null && level.method_8477(pos) && level.method_8321(pos) instanceof PostboxBlockEntity ppbe) {
                        postboxInventory = ppbe.inventory;
                        box = ppbe;
                        box.inventory.sendMode();
                    }
                    int insert = postboxInventory.insert(stack);
                    if (box != null) {
                        box.inventory.receiveMode();
                    }
                    if (insert == 0) {
                        continue;
                    }

                    int extract = carriageInventory.extract(stack, insert);
                    if (extract != insert) {
                        postboxInventory.extract(stack, insert - extract);
                    }
                    if (box == null) {
                        port.primed = true;
                    } else {
                        box.spawnParticles();
                    }
                    Create.RAILWAYS.markTracksDirty();
                    break;
                }
            }

        }
    }

}
