package com.zurrtum.create.content.trains.track;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllTrackMaterials;
import com.zurrtum.create.Create;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

public class TrackMaterial implements class_1935 {
    public static final Map<class_2960, TrackMaterial> ALL = new HashMap<>();
    public static final Codec<TrackMaterial> CODEC = class_2960.field_25139.xmap(TrackMaterial::fromId, TrackMaterial::getId);
    public static final class_9139<ByteBuf, TrackMaterial> PACKET_CODEC = class_2960.field_48267.method_56432(TrackMaterial::fromId, TrackMaterial::getId);

    private final class_2960 id;
    private final Supplier<TrackBlock> trackBlock;
    public Object modelHolder;

    @SuppressWarnings("unchecked")
    public <T> T getModelHolder() {
        return (T) modelHolder;
    }

    public TrackMaterial(class_2960 id, Supplier<TrackBlock> trackBlock) {
        this.id = id;
        this.trackBlock = trackBlock;
        ALL.put(this.id, this);
    }

    public class_2960 getId() {
        return id;
    }

    public TrackBlock getBlock() {
        return trackBlock.get();
    }

    @Override
    public class_1792 method_8389() {
        return trackBlock.get().method_8389();
    }

    public static class_2248[] allBlocks() {
        return ALL.values().stream().map(TrackMaterial::getBlock).toArray(class_2248[]::new);
    }

    public static TrackMaterial fromId(class_2960 id) {
        if (ALL.containsKey(id))
            return ALL.get(id);

        Create.LOGGER.error("Failed to locate serialized track material: {}", id);
        return AllTrackMaterials.ANDESITE;
    }

    public static TrackMaterial fromItem(class_1792 item) {
        if (item instanceof class_1747 blockItem && blockItem.method_7711() instanceof ITrackBlock trackBlock)
            return trackBlock.getMaterial();
        return AllTrackMaterials.ANDESITE;
    }
}