package com.zurrtum.create.content.trains.track;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_3542;

public enum TrackShape implements class_3542 {
    NONE("", class_243.field_1353),
    ZO("z_ortho", new class_243(0, 0, 1)),
    XO("x_ortho", new class_243(1, 0, 0)),
    PD("diag", new class_243(1, 0, 1)),
    ND("diag_2", new class_243(-1, 0, 1)),
    AN("ascending", 180, new class_243(0, 1, -1), new class_243(0, 1, 1)),
    AS("ascending", 0, new class_243(0, 1, 1), new class_243(0, 1, -1)),
    AE("ascending", 270, new class_243(1, 1, 0), new class_243(-1, 1, 0)),
    AW("ascending", 90, new class_243(-1, 1, 0), new class_243(1, 1, 0)),

    TN("teleport", 180, new class_243(0, 0, -1), new class_243(0, 1, 0)),
    TS("teleport", 0, new class_243(0, 0, 1), new class_243(0, 1, 0)),
    TE("teleport", 270, new class_243(1, 0, 0), new class_243(0, 1, 0)),
    TW("teleport", 90, new class_243(-1, 0, 0), new class_243(0, 1, 0)),

    CR_O("cross_ortho", new class_243(0, 0, 1), new class_243(1, 0, 0)),
    CR_D("cross_diag", new class_243(1, 0, 1), new class_243(-1, 0, 1)),
    CR_PDX("cross_d1_xo", new class_243(1, 0, 0), new class_243(1, 0, 1)),
    CR_PDZ("cross_d1_zo", new class_243(0, 0, 1), new class_243(1, 0, 1)),
    CR_NDX("cross_d2_xo", new class_243(1, 0, 0), new class_243(-1, 0, 1)),
    CR_NDZ("cross_d2_zo", new class_243(0, 0, 1), new class_243(-1, 0, 1));

    private String model;
    private List<class_243> axes;
    private int modelRotation;
    private class_243 normal;

    static EnumMap<TrackShape, TrackShape> zMirror = new EnumMap<>(TrackShape.class), xMirror = new EnumMap<>(TrackShape.class), clockwise = new EnumMap<>(
        TrackShape.class);

    static {
        zMirror.putAll(ImmutableMap.<TrackShape, TrackShape>builder().put(PD, ND).put(ND, PD).put(AN, AS).put(AS, AN).put(CR_PDX, CR_NDX)
            .put(CR_NDX, CR_PDX).put(CR_PDZ, CR_NDZ).put(CR_NDZ, CR_PDZ).build());

        xMirror.putAll(ImmutableMap.<TrackShape, TrackShape>builder().put(PD, ND).put(ND, PD).put(AE, AW).put(AW, AE).put(CR_PDX, CR_NDX)
            .put(CR_NDX, CR_PDX).put(CR_PDZ, CR_NDZ).put(CR_NDZ, CR_PDZ).build());

        clockwise.putAll(ImmutableMap.<TrackShape, TrackShape>builder().put(PD, ND).put(ND, PD).put(XO, ZO).put(ZO, XO).put(AE, AS).put(AS, AW)
            .put(AW, AN).put(AN, AE).put(CR_PDX, CR_NDZ).put(CR_NDX, CR_PDZ).put(CR_PDZ, CR_NDX).put(CR_NDZ, CR_PDX).build());
    }

    TrackShape(String model, class_243 axis) {
        this(model, 0, axis, new class_243(0, 1, 0));
    }

    TrackShape(String model, class_243 axis, class_243 secondAxis) {
        this.model = model;
        this.modelRotation = 0;
        this.normal = new class_243(0, 1, 0);
        this.axes = ImmutableList.of(axis, secondAxis);
    }

    TrackShape(String model, int modelRotation, class_243 axis, class_243 normal) {
        this.model = model;
        this.modelRotation = modelRotation;
        this.normal = normal.method_1029();
        this.axes = ImmutableList.of(axis);
    }

    @Override
    public String method_15434() {
        return name().toLowerCase(Locale.ROOT);
    }

    public String getModel() {
        return model;
    }

    public List<class_243> getAxes() {
        return axes;
    }

    public boolean isJunction() {
        return axes.size() > 1;
    }

    public boolean isPortal() {
        return switch (this) {
            case TE, TN, TS, TW -> true;
            default -> false;
        };
    }

    public static TrackShape asPortal(class_2350 horizontalFacing) {
        return switch (horizontalFacing) {
            case field_11034 -> TE;
            case field_11043 -> TN;
            case field_11035 -> TS;
            default -> TW;
        };
    }

    public class_243 getNormal() {
        return normal;
    }

    public int getModelRotation() {
        return modelRotation;
    }

    public TrackShape mirror(class_2415 mirror) {
        return mirror == class_2415.field_11302 ? this : mirror == class_2415.field_11301 ? xMirror.getOrDefault(this, this) : zMirror.getOrDefault(
            this,
            this
        );
    }

    public TrackShape rotate(class_2470 rotation) {
        TrackShape shape = this;
        for (int i = 0; i < rotation.ordinal(); i++)
            shape = clockwise.getOrDefault(shape, shape);
        return shape;
    }

}
