package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.trains.graph.*;
import com.zurrtum.create.content.trains.signal.TrackEdgePoint;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import org.apache.commons.lang3.mutable.MutableObject;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class TrackTargetingBlockItem extends class_1747 {

    private final EdgePointType<?> type;

    public TrackTargetingBlockItem(class_2248 pBlock, class_1793 pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties);
        this.type = type;
    }

    public static TrackTargetingBlockItem station(class_2248 pBlock, class_1793 pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.STATION);
    }

    public static TrackTargetingBlockItem signal(class_2248 pBlock, class_1793 pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.SIGNAL);
    }

    public static TrackTargetingBlockItem observer(class_2248 pBlock, class_1793 pProperties) {
        return new TrackTargetingBlockItem(pBlock, pProperties, EdgePointType.OBSERVER);
    }

    @Override
    public class_1269 method_7884(class_1838 pContext) {
        class_1799 stack = pContext.method_8041();
        class_2338 pos = pContext.method_8037();
        class_1937 level = pContext.method_8045();
        class_2680 state = level.method_8320(pos);
        class_1657 player = pContext.method_8036();

        if (player == null)
            return class_1269.field_5814;

        if (player.method_5715() && stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
            if (level.field_9236)
                return class_1269.field_5812;
            player.method_7353(class_2561.method_43471("create.track_target.clear"), true);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, pos, 1, .5f);
            return class_1269.field_5812;
        }

        if (state.method_26204() instanceof ITrackBlock track) {
            if (level.field_9236)
                return class_1269.field_5812;

            class_243 lookAngle = player.method_5720();
            boolean front = track.getNearestTrackAxis(level, pos, state, lookAngle).getSecond() == class_2352.field_11056;
            EdgePointType<?> type = getType(stack);

            MutableObject<OverlapResult> result = new MutableObject<>(null);
            withGraphLocation(level, pos, front, null, type, (overlap, location) -> result.setValue(overlap));

            if (result.getValue().feedback != null) {
                player.method_7353(class_2561.method_43471("create." + result.getValue().feedback).method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.play(level, null, pos, .5f, 1);
                return class_1269.field_5814;
            }

            stack.method_57379(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS, pos);
            stack.method_57379(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, front);
            stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            player.method_7353(class_2561.method_43471("create.track_target.set"), true);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, pos, 1, 1);
            return class_1269.field_5812;
        }

        if (!stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS)) {
            player.method_7353(class_2561.method_43471("create.track_target.missing").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }

        class_2487 blockEntityData = new class_2487();
        blockEntityData.method_10556("TargetDirection", stack.method_58695(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION, false));

        class_2338 selectedPos = stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        class_2338 placedPos = pos.method_10079(pContext.method_8038(), state.method_45474() ? 0 : 1);

        boolean bezier = stack.method_57826(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);

        if (!selectedPos.method_19771(placedPos, bezier ? AllConfigs.server().trains.maxTrackPlacementLength.get() + 16 : 16)) {
            player.method_7353(class_2561.method_43471("create.track_target.too_far").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }

        if (bezier) {
            BezierTrackPointLocation bezierTrackPointLocation = stack.method_58694(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
            class_2487 bezierNbt = new class_2487();
            bezierNbt.method_10569("Segment", bezierTrackPointLocation.segment());
            bezierNbt.method_67494("Key", class_2338.field_25064, bezierTrackPointLocation.curveTarget().method_10059(placedPos));
            blockEntityData.method_10566("Bezier", bezierNbt);
        }

        blockEntityData.method_67494("TargetTrack", class_2338.field_25064, selectedPos.method_10059(placedPos));
        blockEntityData.method_67494("id", CreateCodecs.BLOCK_ENTITY_TYPE_CODEC, ((IBE<?>) this.method_7711()).getBlockEntityType());

        stack.method_57379(class_9334.field_49611, class_9279.method_57456(blockEntityData));
        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
        stack.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);

        class_1269 useOn = super.method_7884(pContext);
        stack.method_57381(class_9334.field_49611);

        if (level.field_9236 || useOn == class_1269.field_5814)
            return useOn;

        class_1799 itemInHand = player.method_5998(pContext.method_20287());
        if (!itemInHand.method_7960()) {
            itemInHand.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_POS);
            itemInHand.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_SELECTED_DIRECTION);
            itemInHand.method_57381(AllDataComponents.TRACK_TARGETING_ITEM_BEZIER);
        }
        player.method_7353(class_2561.method_43471("create.track_target.success").method_27692(class_124.field_1060), true);

        if (type == EdgePointType.SIGNAL)
            AllAdvancements.SIGNAL.trigger((class_3222) player);

        return useOn;
    }

    public EdgePointType<?> getType(class_1799 stack) {
        return type;
    }

    public enum OverlapResult {

        VALID,
        OCCUPIED("track_target.occupied"),
        JUNCTION("track_target.no_junctions"),
        NO_TRACK("track_target.invalid");

        public String feedback;

        OverlapResult() {
        }

        OverlapResult(String feedback) {
            this.feedback = feedback;
        }

    }

    public static void withGraphLocation(
        class_1937 level,
        class_2338 pos,
        boolean front,
        BezierTrackPointLocation targetBezier,
        EdgePointType<?> type,
        BiConsumer<OverlapResult, TrackGraphLocation> callback
    ) {

        class_2680 state = level.method_8320(pos);

        if (!(state.method_26204() instanceof ITrackBlock track)) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }

        List<class_243> trackAxes = track.getTrackAxes(level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(OverlapResult.JUNCTION, null);
            return;
        }

        class_2352 targetDirection = front ? class_2352.field_11056 : class_2352.field_11060;
        TrackGraphLocation location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt(
            level,
            pos,
            targetDirection,
            targetBezier
        ) : TrackGraphHelper.getGraphLocationAt(level, pos, targetDirection, trackAxes.getFirst());

        if (location == null) {
            callback.accept(OverlapResult.NO_TRACK, null);
            return;
        }

        Couple<TrackNode> nodes = location.edge.map(location.graph::locateNode);
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null)
            return;

        EdgeData edgeData = edge.getEdgeData();
        double edgePosition = location.position;

        for (TrackEdgePoint edgePoint : edgeData.getPoints()) {
            double otherEdgePosition = edgePoint.getLocationOn(edge);
            double distance = Math.abs(edgePosition - otherEdgePosition);
            if (distance > .75)
                continue;
            if (edgePoint.canCoexistWith(type, front) && distance < .25)
                continue;

            callback.accept(OverlapResult.OCCUPIED, location);
            return;
        }

        callback.accept(OverlapResult.VALID, location);
    }

}
