package com.zurrtum.create.foundation;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.codecs.CatnipCodecUtils;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9323;

public class CreateNBTProcessors {
    public static void register() {
        NBTProcessors.addProcessor(
            class_2591.field_16412, data -> {
                if (!data.method_10545("Book"))
                    return data;
                class_2487 book = data.method_68568("Book");

                // Writable books can't have click events, so they're safe to keep
                class_2960 writableBookResource = class_7923.field_41178.method_10221(class_1802.field_8674);
                if (writableBookResource != class_7923.field_41178.method_10137() && book.method_68564("id", "").equals(writableBookResource.toString()))
                    return data;

                class_9302 bookContent = CatnipCodecUtils.decodeOrNull(class_9302.field_49381, book);
                if (bookContent == null)
                    return data;

                for (class_9262<class_2561> page : bookContent.comp_2422()) {
                    if (NBTProcessors.textComponentHasClickEvent(page.method_57140(false)))
                        return null;
                }

                return data;
            }
        );

        NBTProcessors.addProcessor(AllBlockEntityTypes.CLIPBOARD, CreateNBTProcessors::clipboardProcessor);

        NBTProcessors.addProcessor(AllBlockEntityTypes.CREATIVE_CRATE, NBTProcessors.itemProcessor("Filter"));
    }

    public static class_2487 clipboardProcessor(class_2487 data) {
        class_9323 components = data.method_10562("components").flatMap(c -> CatnipCodecUtils.decode(class_9323.field_50234, c)).orElse(null);
        if (components == null)
            return data;

        ClipboardContent content = components.method_58694(AllDataComponents.CLIPBOARD_CONTENT);
        if (content == null)
            return data;

        for (List<ClipboardEntry> entries : content.pages()) {
            for (ClipboardEntry entry : entries) {
                if (NBTProcessors.textComponentHasClickEvent(entry.text))
                    return null;
            }
        }

        return data;
    }
}