package com.zurrtum.create.foundation.fluid;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface FluidIngredientSerializer {
    Map<String, FluidIngredientSerializer> REGISTRY = new HashMap<>();
    Codec<FluidIngredientSerializer> CODEC = Codec.STRING.xmap(REGISTRY::get, FluidIngredientSerializer::type);
    class_9139<class_9129, FluidIngredientSerializer> PACKET_CODEC = class_9139.method_56438(
        (serializer, buf) -> buf.method_10814(serializer.type()),
        buf -> REGISTRY.get(buf.method_19772())
    );
    FluidIngredientSerializer FLUID_STACK = register("fluid_stack", FluidStackIngredient.Serializer::new);
    FluidIngredientSerializer FLUID_TAG = register("fluid_tag", FluidTagIngredient.Serializer::new);

    String type();

    MapCodec<? extends FluidIngredient> codec();

    class_9139<class_9129, ? extends FluidIngredient> packetCodec();

    static FluidIngredientSerializer register(String type, Function<String, FluidIngredientSerializer> factory) {
        FluidIngredientSerializer serializer = factory.apply(type);
        REGISTRY.put(type, serializer);
        return serializer;
    }
}
