package com.zurrtum.create.foundation.pack;

import com.google.gson.JsonElement;
import com.zurrtum.create.Create;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7677;
import net.minecraft.class_9224;
import net.minecraft.resource.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.*;

// TODO - Move into catnip
public class DynamicPack implements class_3262 {
    private final Map<String, class_7367<InputStream>> files = new HashMap<>();

    private final String packId;
    private final class_3264 packType;
    private final class_3272 metadata;
    private final class_9224 packLocationInfo;

    public DynamicPack(String packId, class_2561 title, class_3264 packType) {
        this.packId = packId;
        this.packType = packType;

        metadata = new class_3272(title, class_155.method_16673().method_70592(packType), Optional.empty());
        packLocationInfo = new class_9224(packId, class_2561.method_43470(packId), class_5352.field_25348, Optional.empty());
    }

    private static String getPath(class_3264 packType, class_2960 identifier) {
        return packType.method_14413() + "/" + identifier.method_12836() + "/" + identifier.method_12832();
    }

    public DynamicPack put(class_2960 location, class_7367<InputStream> stream) {
        files.put(getPath(packType, location), stream);
        return this;
    }

    public DynamicPack put(class_2960 location, byte[] bytes) {
        return put(location, () -> new ByteArrayInputStream(bytes));
    }

    public DynamicPack put(class_2960 location, String string) {
        return put(location, string.getBytes(StandardCharsets.UTF_8));
    }

    // Automatically suffixes the Identifier with .json
    public DynamicPack put(class_2960 location, JsonElement json) {
        return put(location.method_48331(".json"), Create.GSON.toJson(json));
    }

    public boolean isEmpty() {
        return files.isEmpty();
    }

    @Override
    public @Nullable class_7367<InputStream> method_14410(String @NotNull ... elements) {
        return files.getOrDefault(String.join("/", elements), null);
    }

    @Override
    public @Nullable class_7367<InputStream> method_14405(@NotNull class_3264 packType, @NotNull class_2960 identifier) {
        return files.getOrDefault(getPath(packType, identifier), null);
    }

    @Override
    public void method_14408(
        @NotNull class_3264 packType,
        @NotNull String namespace,
        @NotNull String path,
        @NotNull class_7664 resourceOutput
    ) {
        class_2960 identifier = class_2960.method_60655(namespace, path);
        String directoryAndNamespace = packType.method_14413() + "/" + namespace + "/";
        String prefix = directoryAndNamespace + path + "/";
        files.forEach((filePath, streamSupplier) -> {
            if (filePath.startsWith(prefix))
                resourceOutput.accept(identifier.method_45136(filePath.substring(directoryAndNamespace.length())), streamSupplier);
        });
    }

    @Override
    public @NotNull Set<String> method_14406(class_3264 packType) {
        Set<String> namespaces = new HashSet<>();
        String dir = packType.method_14413() + "/";

        for (String path : files.keySet()) {
            if (path.startsWith(dir)) {
                String relative = path.substring(dir.length());
                if (relative.contains("/")) {
                    namespaces.add(relative.substring(0, relative.indexOf("/")));
                }
            }
        }

        return namespaces;
    }

    @SuppressWarnings("unchecked")
    @Override
    public @Nullable <T> T method_14407(@NotNull class_7677<T> deserializer) throws IOException {
        return deserializer == class_3272.field_14202 ? (T) metadata : null;
    }

    @Override
    public @NotNull class_9224 method_56926() {
        return packLocationInfo;
    }

    @Override
    public @NotNull String method_14409() {
        return packId;
    }

    @Override
    public void close() {
    } // NO-OP
}