package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PackageOrderData(
    int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, @Nullable PackageOrderWithCrafts orderContext
) {
    public PackageOrderData(
        int orderId,
        int linkIndex,
        boolean isFinalLink,
        int fragmentIndex,
        boolean isFinal,
        Optional<PackageOrderWithCrafts> orderContext
    ) {
        this(orderId, linkIndex, isFinalLink, fragmentIndex, isFinal, orderContext.orElse(null));
    }

    public static final Codec<PackageOrderData> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        Codec.INT.fieldOf("order_id").forGetter(PackageOrderData::orderId),
        Codec.INT.fieldOf("link_index").forGetter(PackageOrderData::linkIndex),
        Codec.BOOL.fieldOf("is_final_link").forGetter(PackageOrderData::isFinalLink),
        Codec.INT.fieldOf("fragment_index").forGetter(PackageOrderData::fragmentIndex),
        Codec.BOOL.fieldOf("is_final").forGetter(PackageOrderData::isFinal),
        PackageOrderWithCrafts.CODEC.optionalFieldOf("order_context").forGetter(i -> Optional.ofNullable(i.orderContext))
    ).apply(instance, PackageOrderData::new));

    public static final class_9139<class_9129, PackageOrderData> STREAM_CODEC = class_9139.method_58025(
        class_9135.field_49675,
        PackageOrderData::orderId,
        class_9135.field_49675,
        PackageOrderData::linkIndex,
        class_9135.field_48547,
        PackageOrderData::isFinalLink,
        class_9135.field_49675,
        PackageOrderData::fragmentIndex,
        class_9135.field_48547,
        PackageOrderData::isFinal,
        CatnipStreamCodecBuilders.nullable(PackageOrderWithCrafts.STREAM_CODEC),
        PackageOrderData::orderContext,
        PackageOrderData::new
    );
}