package com.zurrtum.create.infrastructure.component;

import com.mojang.serialization.Codec;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.equipment.zapper.ZapperItem;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.FlattenTool;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_9139;

public enum TerrainTools implements class_3542 {
    Fill,
    Place,
    Replace,
    Clear,
    Overlay,
    Flatten;

    public static final Codec<TerrainTools> CODEC = class_3542.method_28140(TerrainTools::values);
    public static final class_9139<ByteBuf, TerrainTools> STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(TerrainTools.class);
    public final String translationKey;

    TerrainTools() {
        this.translationKey = name().toLowerCase(Locale.ROOT);
    }

    @Override
    public @NotNull String method_15434() {
        return translationKey;
    }

    public boolean requiresSelectedBlock() {
        return this != Clear && this != Flatten;
    }

    public void run(
        class_1937 world,
        List<class_2338> targetPositions,
        class_2350 facing,
        @Nullable class_2680 paintedState,
        @Nullable class_2487 data,
        class_1657 player
    ) {
        switch (this) {
            case Clear:
                targetPositions.forEach(p -> world.method_8501(p, class_2246.field_10124.method_9564()));
                break;
            case Fill:
                targetPositions.forEach(p -> {
                    class_2680 toReplace = world.method_8320(p);
                    if (!isReplaceable(toReplace))
                        return;
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            case Flatten:
                FlattenTool.apply(world, targetPositions, facing);
                break;
            case Overlay:
                targetPositions.forEach(p -> {
                    class_2680 toOverlay = world.method_8320(p);
                    if (isReplaceable(toOverlay))
                        return;
                    if (toOverlay == paintedState)
                        return;

                    p = p.method_10084();

                    class_2680 toReplace = world.method_8320(p);
                    if (!isReplaceable(toReplace))
                        return;
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            case Place:
                targetPositions.forEach(p -> {
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
            case Replace:
                targetPositions.forEach(p -> {
                    class_2680 toReplace = world.method_8320(p);
                    if (isReplaceable(toReplace))
                        return;
                    world.method_8501(p, paintedState);
                    ZapperItem.setBlockEntityData(world, p, paintedState, data, player);
                });
                break;
        }
    }

    public static boolean isReplaceable(class_2680 toReplace) {
        return toReplace.method_45474();
    }
}
