package com.zurrtum.create.infrastructure.packet.s2c;

import com.zurrtum.create.AllPackets;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.depot.EjectorItemEntity;
import com.zurrtum.create.content.logistics.depot.EntityLauncher;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_3231;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9145;

public class EjectorItemSpawnPacket extends class_2604 {
    private final boolean alive;
    private final int progress;
    private final boolean hasLauncher;
    private final EntityLauncher launcher;
    private final class_2350 direction;
    public static final class_9139<class_9129, EjectorItemSpawnPacket> field_47896 = class_2596.method_56443(
        EjectorItemSpawnPacket::method_55855,
        EjectorItemSpawnPacket::new
    );

    public EjectorItemSpawnPacket(EjectorItemEntity entity, class_3231 entityTrackerEntry) {
        super(entity, entityTrackerEntry);
        alive = entity.method_5805();
        hasLauncher = !alive && !(entity.method_37908().method_8321(entity.method_24515()) instanceof EjectorBlockEntity);
        if (hasLauncher) {
            progress = entity.progress;
            launcher = entity.launcher;
            direction = entity.direction;
        } else {
            progress = 0;
            launcher = null;
            direction = null;
        }
    }

    private EjectorItemSpawnPacket(class_9129 buf) {
        super(buf);
        alive = buf.readBoolean();
        progress = buf.readInt();
        if (!alive) {
            hasLauncher = buf.readBoolean();
            if (hasLauncher) {
                launcher = EntityLauncher.PACKET_CODEC.decode(buf);
                direction = class_2350.field_48450.decode(buf);
                return;
            }
        } else {
            hasLauncher = false;
        }
        launcher = null;
        direction = null;
    }

    @Override
    public void method_55855(class_9129 buf) {
        super.method_55855(buf);
        buf.method_52964(alive);
        buf.method_53002(progress);
        if (!alive) {
            buf.method_52964(hasLauncher);
            if (hasLauncher) {
                EntityLauncher.PACKET_CODEC.encode(buf, launcher);
                class_2350.field_48450.encode(buf, direction);
            }
        }
    }

    public boolean getAlive() {
        return alive;
    }

    public int getProgress() {
        return progress;
    }

    public EntityLauncher getLauncher() {
        return launcher;
    }

    public class_2350 getDirection() {
        return direction;
    }

    public boolean hasLauncher() {
        return hasLauncher;
    }

    @Override
    @SuppressWarnings("unchecked")
    public class_9145<class_2604> method_65080() {
        return (class_9145<class_2604>) (class_9145<?>) AllPackets.EJECTOR_ITEM_SPAWN;
    }
}
