package com.zurrtum.create.infrastructure.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.data.Couple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3124;
import net.minecraft.class_3481;
import net.minecraft.class_3798;
import net.minecraft.class_3825;
import net.minecraft.class_5819;

public class LayerPattern {
    public static final Codec<LayerPattern> CODEC = Codec.list(Layer.CODEC).xmap(LayerPattern::new, pattern -> pattern.layers);

    public final List<Layer> layers;

    public LayerPattern(List<Layer> layers) {
        this.layers = layers;
    }

    public Layer rollNext(@Nullable Layer previous, class_5819 random) {
        int totalWeight = 0;
        for (Layer layer : layers)
            if (layer != previous)
                totalWeight += layer.weight;
        int rolled = random.method_43048(totalWeight);

        for (Layer layer : layers) {
            if (layer == previous)
                continue;
            rolled -= layer.weight;
            if (rolled < 0)
                return layer;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Layer> layers = new ArrayList<>();
        private boolean netherMode;

        public Builder inNether() {
            netherMode = true;
            return this;
        }

        public Builder layer(Consumer<Layer.@NotNull Builder> builder) {
            Layer.Builder layerBuilder = new Layer.Builder();
            layerBuilder.netherMode = netherMode;
            builder.accept(layerBuilder);
            layers.add(layerBuilder.build());
            return this;
        }

        public LayerPattern build() {
            return new LayerPattern(layers);
        }
    }

    public static class Layer {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            Codec.list(Codec.list(class_3124.class_5876.field_29067)).fieldOf("targets").forGetter(layer -> layer.targets),
            Codec.intRange(0, Integer.MAX_VALUE).fieldOf("min_size").forGetter(layer -> layer.minSize),
            Codec.intRange(0, Integer.MAX_VALUE).fieldOf("max_size").forGetter(layer -> layer.maxSize),
            Codec.intRange(0, Integer.MAX_VALUE).fieldOf("weight").forGetter(layer -> layer.weight)
        ).apply(instance, Layer::new));

        public final List<List<class_3124.class_5876>> targets;
        public final int minSize;
        public final int maxSize;
        public final int weight;

        public Layer(List<List<class_3124.class_5876>> targets, int minSize, int maxSize, int weight) {
            this.targets = targets;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.weight = weight;
        }

        public List<class_3124.class_5876> rollBlock(class_5819 random) {
            if (targets.size() == 1)
                return targets.getFirst();
            return targets.get(random.method_43048(targets.size()));
        }

        public static class Builder {
            private static final class_3825 STONE_ORE_REPLACEABLES = new class_3798(class_3481.field_28992);
            private static final class_3825 DEEPSLATE_ORE_REPLACEABLES = new class_3798(class_3481.field_28993);
            private static final class_3825 NETHER_ORE_REPLACEABLES = new class_3798(class_3481.field_25807);

            private final List<List<class_3124.class_5876>> targets = new ArrayList<>();
            private int minSize = 1;
            private int maxSize = 1;
            private int weight = 1;
            private boolean netherMode;

            public com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder block(Supplier<? extends class_2248> block) {
                return block(block.get());
            }

            public com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder passiveBlock() {
                return blocks(class_2246.field_10340.method_9564(), class_2246.field_28888.method_9564());
            }

            public com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder block(class_2248 block) {
                if (netherMode) {
                    this.targets.add(ImmutableList.of(class_3124.method_33994(NETHER_ORE_REPLACEABLES, block.method_9564())));
                    return this;
                }
                return blocks(block.method_9564(), block.method_9564());
            }

            public com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder blocks(class_2248 block, class_2248 deepblock) {
                return blocks(block.method_9564(), deepblock.method_9564());
            }

            public com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder blocks(Couple<Supplier<? extends class_2248>> blocksByDepth) {
                return blocks(blocksByDepth.getFirst().get().method_9564(), blocksByDepth.getSecond().get().method_9564());
            }

            private com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder blocks(class_2680 stone, class_2680 deepslate) {
                this.targets.add(ImmutableList.of(
                    class_3124.method_33994(STONE_ORE_REPLACEABLES, stone),
                    class_3124.method_33994(DEEPSLATE_ORE_REPLACEABLES, deepslate)
                ));
                return this;
            }

            public com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder weight(int weight) {
                this.weight = weight;
                return this;
            }

            public com.zurrtum.create.infrastructure.worldgen.LayerPattern.Layer.Builder size(int min, int max) {
                this.minSize = min;
                this.maxSize = max;
                return this;
            }

            public Layer build() {
                return new Layer(targets, minSize, maxSize, weight);
            }
        }
    }
}