package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_9903;
import net.minecraft.class_9904;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_9903.class)
public class ExperimentalRedstoneControllerMixin {
    @WrapOperation(method = "method_61833(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/lang/Integer;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;updateNeighbor(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/world/block/WireOrientation;Z)V"))
    private void updateNeighbor(
        class_1937 world,
        class_2680 state,
        class_2338 neighborPos,
        class_2248 sourceBlock,
        class_9904 orientation,
        boolean notify,
        Operation<Void> original,
        @Local(argsOnly = true) class_2338 pos
    ) {
        if (state.method_26204() instanceof NeighborUpdateListeningBlock block) {
            block.neighborUpdate(state, world, neighborPos, sourceBlock, pos, notify);
        }
        original.call(world, state, neighborPos, sourceBlock, orientation, notify);
    }

    @WrapOperation(method = "method_61833(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/lang/Integer;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;updateNeighbor(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/world/block/WireOrientation;)V"))
    private void updateNeighbor(
        class_1937 world,
        class_2338 neighborPos,
        class_2248 sourceBlock,
        class_9904 orientation,
        Operation<Void> original,
        @Local(ordinal = 1) class_2338 pos
    ) {
        class_2680 state = world.method_8320(neighborPos);
        if (state.method_26204() instanceof NeighborUpdateListeningBlock block) {
            block.neighborUpdate(state, world, neighborPos, sourceBlock, pos, false);
        }
        original.call(world, neighborPos, sourceBlock, orientation);
    }
}
