package com.zurrtum.create.mixin;

import com.zurrtum.create.infrastructure.fluids.FluidInteractionRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2404.class)
public class FluidBlockMixin {
    @Inject(method = "receiveNeighborFluids(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z", at = @At("HEAD"), cancellable = true)
    private void receiveNeighborFluids(class_1937 world, class_2338 pos, class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        if (FluidInteractionRegistry.canInteract(world, pos)) {
            cir.setReturnValue(false);
        }
    }
}