/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.AsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + CacheManager.class.getSimpleName()));
    private static final Map<class_5321<class_1937>, CacheStorage> STATES = new ConcurrentHashMap<class_5321<class_1937>, CacheStorage>();

    private CacheManager() {
    }

    public static void register() {
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_8608()) {
                return;
            }
            CacheManager.load(world);
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (world.method_8608()) {
                return;
            }
            CacheManager.save(world);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            for (class_3218 world : server.method_3738()) {
                CacheManager.save(world);
            }
        });
    }

    private static CacheStorage state(class_3218 world) {
        return STATES.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> CacheStorage.get(world));
    }

    private static void load(class_3218 world) {
        CacheStorage storage = CacheStorage.get(world);
        STATES.put((class_5321<class_1937>)world.method_27983(), storage);
        LOGGER.debug("Cache loaded for world {}", (Object)world.method_27983().method_29177());
    }

    private static void save(class_3218 world) {
        CacheStorage storage = STATES.remove(world.method_27983());
        if (storage != null) {
            storage.method_80();
            LOGGER.debug("Cache saved for world {}", (Object)world.method_27983().method_29177());
        }
    }

    public static void prefill(class_3218 world, int minX, int minZ, int maxX, int maxZ) {
        int step = 4;
        CacheStorage storage = CacheManager.state(world);
        AsyncExecutor.execute(() -> {
            class_2794 gen = world.method_14178().method_12129();
            class_7138 cfg = world.method_14178().method_41248();
            class_6544.class_6552 sampler = cfg.method_42371();
            class_1966 bsrc = gen.method_12098();
            for (int x = minX; x <= maxX; x += step) {
                for (int z = minZ; z <= maxZ; z += step) {
                    long key = CacheManager.hash(x, z);
                    int finalX = x;
                    int finalZ = z;
                    AsyncExecutor.execute(() -> {
                        int h = gen.method_16397(finalX, finalZ, class_2902.class_2903.field_13194, (class_5539)world, cfg);
                        class_6880 biome = bsrc.method_38109(class_5742.method_33100((int)finalX), 316, class_5742.method_33100((int)finalZ), sampler);
                        storage.heights().put(key, h);
                        storage.biomes().put(key, (class_6880<class_1959>)biome);
                    });
                }
            }
            LOGGER.debug("Prefill complete [{}..{}]\u00d7[{}..{}]", new Object[]{minX, maxX, minZ, maxZ});
        });
    }

    public static int getHeight(class_3218 world, long key, IntSupplier loader) {
        return CacheManager.state(world).heights().computeIfAbsent(key, k -> loader.getAsInt());
    }

    public static int getHeight(class_3218 world, int x, int z) {
        class_2794 gen = world.method_14178().method_12129();
        class_7138 cfg = world.method_14178().method_41248();
        long key = CacheManager.hash(x, z);
        return CacheManager.getHeight(world, key, () -> gen.method_16397(x, z, class_2902.class_2903.field_13194, (class_5539)world, cfg));
    }

    public static double getStability(class_3218 world, long key, DoubleSupplier loader) {
        return CacheManager.state(world).stabilities().computeIfAbsent(key, k -> loader.getAsDouble());
    }

    public static class_6880<class_1959> getBiome(class_3218 world, long key, Supplier<class_6880<class_1959>> loader) {
        return CacheManager.state(world).biomes().computeIfAbsent(key, k -> (class_6880)loader.get());
    }

    public static long hash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static class_2338 keyToPos(long k) {
        return new class_2338((int)(k >> 32), 0, (int)k);
    }
}

