/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.fabric.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_1269;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.oxcodsnet.roadarchitect.config.RAConfig;
import net.oxcodsnet.roadarchitect.config.RAConfigHolder;
import net.oxcodsnet.roadarchitect.config.RoadArchitectConfigData;
import net.oxcodsnet.roadarchitect.config.defaults.BopRoadStyleDefaults;
import net.oxcodsnet.roadarchitect.config.defaults.LampPostDefaults;
import net.oxcodsnet.roadarchitect.config.defaults.RoadStyleDefaults;
import net.oxcodsnet.roadarchitect.config.records.CacheSettings;
import net.oxcodsnet.roadarchitect.config.records.LampPostConfigEntry;
import net.oxcodsnet.roadarchitect.config.records.RoadStyleConfigEntry;
import net.oxcodsnet.roadarchitect.handlers.RoadPipelineController;
import net.oxcodsnet.roadarchitect.handlers.compat.BopCompat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RAConfigFabricBridge {
    private static final Logger LOG = LoggerFactory.getLogger((String)"RoadArchitect/ConfigBridge");
    private static ConfigHolder<RoadArchitectConfigData> holder;

    private RAConfigFabricBridge() {
    }

    public static void bootstrap() {
        holder = AutoConfig.register(RoadArchitectConfigData.class, GsonConfigSerializer::new);
        if (!BopCompat.isPresent()) {
            RAConfigFabricBridge.registerBopInstallHint();
        }
        RAConfigHolder.set(new RAConfig(){

            @Override
            public int initScanRadius() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).initScanRadius;
            }

            @Override
            public int chunkGenerateScanRadius() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).chunkGenerateScanRadius;
            }

            @Override
            public int maxConnectionDistance() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).maxConnectionDistance;
            }

            @Override
            public int pipelineIntervalSeconds() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).pipelineIntervalSeconds;
            }

            @Override
            public int lampInterval() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).lampInterval;
            }

            @Override
            public int roadWidth() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).roadWidth;
            }

            @Override
            public int sideDecorationInterval() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).sideDecorationInterval;
            }

            @Override
            public int buoyInterval() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).buoyInterval;
            }

            @Override
            public int maskErosion() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).maskErosion;
            }

            @Override
            public boolean deterministicDecorations() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).deterministicDecorations;
            }

            @Override
            public List<String> structureSelectors() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).structureSelectors;
            }

            @Override
            public List<String> dimensionSelectors() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).dimensionSelectors;
            }

            @Override
            public boolean terrainAnalyzerEnabled() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).terrainAnalyzer.enabled;
            }

            @Override
            public int terrainRoughRadius() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).terrainAnalyzer.roughRadius;
            }

            @Override
            public int terrainRoughStride() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).terrainAnalyzer.roughStride;
            }

            @Override
            public int terrainRangeThreshold() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).terrainAnalyzer.roughRangeThreshold;
            }

            @Override
            public double terrainPenaltyScale() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).terrainAnalyzer.roughPenaltyScale;
            }

            @Override
            public boolean preferLandOverWater() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).pathfinding.preferLandOverWater;
            }

            @Override
            public double waterStepPenalty() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).pathfinding.waterStepPenalty;
            }

            @Override
            public int coastAvoidBufferBlocks() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).pathfinding.coastAvoidBufferBlocks;
            }

            @Override
            public double coastProximityPenalty() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).pathfinding.coastProximityPenalty;
            }

            @Override
            public List<String> forbiddenBiomeSelectors() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).forbiddenBiomes.selectors;
            }

            @Override
            public int forbiddenBiomeBufferBlocks() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).forbiddenBiomes.bufferBlocks;
            }

            @Override
            public double forbiddenBiomeProximityPenalty() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).forbiddenBiomes.proximityPenalty;
            }

            @Override
            public boolean acceptPartialPaths() {
                return ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).pathfinding.acceptHighProgressPartial;
            }

            @Override
            public double partialProgressThreshold() {
                int pct = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).pathfinding.partialProgressPercent;
                if (pct <= 0) {
                    return 0.0;
                }
                if (pct >= 100) {
                    return 1.0;
                }
                return (double)pct / 100.0;
            }

            @Override
            public List<LampPostConfigEntry> lampPostOverrides() {
                RoadArchitectConfigData.LampPostSettings settings = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).lampPosts;
                if (settings == null) {
                    return LampPostDefaults.entries();
                }
                if (!settings.enabled) {
                    return LampPostDefaults.entries();
                }
                List<RoadArchitectConfigData.LampPostDefinition> defs = settings.overrides;
                if (defs == null || defs.isEmpty()) {
                    return LampPostDefaults.entries();
                }
                ArrayList<LampPostConfigEntry> out = new ArrayList<LampPostConfigEntry>(defs.size());
                for (RoadArchitectConfigData.LampPostDefinition def : defs) {
                    if (def == null) continue;
                    out.add(new LampPostConfigEntry(def.biomeSelectors, def.baseBlock, def.postBlock, def.lampBlock));
                }
                return List.copyOf(out);
            }

            @Override
            public List<RoadStyleConfigEntry> roadStyleOverrides() {
                RoadArchitectConfigData.RoadStyleSettings settings = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).roadStyles;
                if (settings == null || !settings.enabled) {
                    return RoadStyleDefaults.entries();
                }
                return RAConfigFabricBridge.compileRoadStyles(settings.overrides, RoadStyleDefaults.entries());
            }

            @Override
            public List<RoadStyleConfigEntry> bopRoadStyleOverrides() {
                if (!BopCompat.isPresent()) {
                    return List.of();
                }
                RoadArchitectConfigData.BopRoadStyleSettings settings = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).bopRoadStyles;
                if (settings == null || !settings.enabled) {
                    return BopRoadStyleDefaults.entries();
                }
                return RAConfigFabricBridge.compileRoadStyles(settings.overrides, BopRoadStyleDefaults.entries());
            }

            @Override
            public boolean debugVerboseLogs() {
                RoadArchitectConfigData.DebugSettings settings = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).debug;
                return settings != null && settings.enableVerboseLogs;
            }

            @Override
            public boolean debugPipelineProfiler() {
                RoadArchitectConfigData.DebugSettings settings = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).debug;
                return settings != null && settings.enablePipelineProfiler;
            }

            @Override
            public boolean debugCacheLogs() {
                RoadArchitectConfigData.DebugSettings settings = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).debug;
                return settings != null && settings.enableCacheLogs;
            }

            @Override
            public boolean debugCacheOverlay() {
                RoadArchitectConfigData.DebugSettings settings = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).debug;
                return settings != null && settings.showCacheStatsOverlay;
            }

            @Override
            public CacheSettings cache() {
                RoadArchitectConfigData.CacheSection section = ((RoadArchitectConfigData)RAConfigFabricBridge.holder.getConfig()).cache;
                if (section == null) {
                    return CacheSettings.DEFAULT;
                }
                return new CacheSettings(section.runtimeBudgetMb, section.snapshotBudgetMb, section.persistedBudgetMb, section.regionSizeChunks, section.enablePrefill, section.prefillMaxChunks, section.persistHeights, section.persistStabilities, section.persistBiomes);
            }
        });
        holder.registerSaveListener((h, cfg) -> {
            RoadPipelineController.refreshStructureSelectorCache();
            LOG.info("[RoadArchitect] config reloaded");
            return class_1269.field_5811;
        });
        LOG.info("[RoadArchitect] cloth-config bridge initialized");
    }

    private static void registerBopInstallHint() {
        try {
            Method getGuiRegistry = AutoConfig.class.getMethod("getGuiRegistry", Class.class);
            GuiRegistry registry = (GuiRegistry)getGuiRegistry.invoke(null, RoadArchitectConfigData.class);
            if (registry == null) {
                LOG.warn("AutoConfig#getGuiRegistry returned null; skipping BOP install hint registration.");
                return;
            }
            registry.registerPredicateProvider((name, field, config, defaults, guiRegistry) -> List.of(ConfigEntryBuilder.create().startTextDescription((class_2561)class_2561.method_43471((String)"text.autoconfig.roadarchitect.option.bopRoadStyles.installHint")).build()), field -> field.getDeclaringClass() == RoadArchitectConfigData.class && field.getType() == RoadArchitectConfigData.BopRoadStyleSettings.class);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Cloth Config no longer exposes AutoConfig#getGuiRegistry; skipping BOP install hint.");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Failed to register BOP install hint with Cloth Config.", (Throwable)e);
        }
    }

    private static List<RoadStyleConfigEntry> compileRoadStyles(List<RoadArchitectConfigData.RoadStyleDefinition> definitions, List<RoadStyleConfigEntry> defaults) {
        if (definitions == null || definitions.isEmpty()) {
            return defaults;
        }
        ArrayList<RoadStyleConfigEntry> out = new ArrayList<RoadStyleConfigEntry>(definitions.size());
        for (RoadArchitectConfigData.RoadStyleDefinition def : definitions) {
            RoadStyleConfigEntry roadStyleConfigEntry;
            if (def == null) continue;
            ArrayList<RoadStyleConfigEntry.SurfaceBlockEntry> palette = new ArrayList<RoadStyleConfigEntry.SurfaceBlockEntry>();
            if (def.palette != null) {
                for (RoadArchitectConfigData.RoadPaletteEntry roadPaletteEntry : def.palette) {
                    if (roadPaletteEntry == null) continue;
                    palette.add(new RoadStyleConfigEntry.SurfaceBlockEntry(roadPaletteEntry.block, roadPaletteEntry.weight));
                }
            }
            ArrayList<RoadStyleConfigEntry.DecorationEntry> decorations = new ArrayList<RoadStyleConfigEntry.DecorationEntry>();
            if (def.decorations != null) {
                for (RoadArchitectConfigData.RoadDecorationEntry entry2 : def.decorations) {
                    if (entry2 == null) continue;
                    decorations.add(new RoadStyleConfigEntry.DecorationEntry(entry2.type, entry2.block));
                }
            }
            if ((roadStyleConfigEntry = new RoadStyleConfigEntry(def.biomeSelectors, palette, decorations)).palette().isEmpty()) {
                LOG.warn("Skipping road style override with empty palette for selectors {}", def.biomeSelectors);
                continue;
            }
            out.add(roadStyleConfigEntry);
        }
        if (out.isEmpty()) {
            return defaults;
        }
        return List.copyOf(out);
    }

    public static class_437 createScreen(class_437 parent) {
        return (class_437)AutoConfig.getConfigScreen(RoadArchitectConfigData.class, (class_437)parent).get();
    }
}

