/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.config.RAConfig;
import net.oxcodsnet.roadarchitect.config.RAConfigHolder;
import net.oxcodsnet.roadarchitect.config.RoadDecorationType;
import net.oxcodsnet.roadarchitect.config.defaults.RoadStyleDefaults;
import net.oxcodsnet.roadarchitect.config.records.RoadStyleConfigEntry;
import net.oxcodsnet.roadarchitect.handlers.compat.BopCompat;
import net.oxcodsnet.roadarchitect.util.BiomeSelectorUtil;
import net.oxcodsnet.roadarchitect.worldgen.style.BlockPalette;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyle;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.FenceDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadStyles {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadArchitect/RoadStyles");
    private static final AtomicInteger VERSION = new AtomicInteger();
    private static final Map<class_2378<class_1959>, CacheEntry> CACHE = new ConcurrentHashMap<class_2378<class_1959>, CacheEntry>();
    private static volatile List<ParsedStyle> STYLES = List.of();
    private static volatile RoadStyle FALLBACK = RoadStyles.buildFallbackFromDefaults();

    private RoadStyles() {
    }

    public static RoadStyle forBiome(class_2378<class_1959> registry, class_6880<class_1959> biomeEntry) {
        if (registry == null || biomeEntry == null) {
            return FALLBACK;
        }
        CacheEntry cache = CACHE.compute(registry, (reg, existing) -> {
            int current = VERSION.get();
            if (existing != null && existing.version == current) {
                return existing;
            }
            ArrayList<CompiledStyle> compiled = new ArrayList<CompiledStyle>(STYLES.size());
            for (ParsedStyle parsed : STYLES) {
                List<String> selectors = parsed.selectors();
                List<class_6885<class_1959>> compiledSelectors = selectors.isEmpty() ? List.of() : BiomeSelectorUtil.compile((class_2378<class_1959>)reg, selectors);
                compiled.add(new CompiledStyle(parsed.style(), compiledSelectors));
            }
            return new CacheEntry(current, List.copyOf(compiled));
        });
        RoadStyle fallback = FALLBACK;
        for (CompiledStyle compiled : cache.styles()) {
            List<class_6885<class_1959>> selectors = compiled.selectors();
            if (selectors.isEmpty()) {
                fallback = compiled.style();
                continue;
            }
            if (!BiomeSelectorUtil.matches(biomeEntry, selectors)) continue;
            return compiled.style();
        }
        return fallback;
    }

    private static void reload(RAConfig config) {
        List<RoadStyleConfigEntry> bopOverrides;
        List<RoadStyleConfigEntry> entries = config.roadStyleOverrides();
        List<RoadStyleConfigEntry> baseSource = entries == null || entries.isEmpty() ? RoadStyleDefaults.entries() : entries;
        List<Object> bopEntries = List.of();
        if (BopCompat.isPresent() && (bopOverrides = config.bopRoadStyleOverrides()) != null && !bopOverrides.isEmpty()) {
            bopEntries = bopOverrides;
        }
        ArrayList<RoadStyleConfigEntry> source = new ArrayList<RoadStyleConfigEntry>(baseSource.size() + bopEntries.size());
        source.addAll(baseSource);
        source.addAll(bopEntries);
        ArrayList<ParsedStyle> parsed = new ArrayList<ParsedStyle>(source.size());
        RoadStyle fallback = null;
        for (RoadStyleConfigEntry entry : source) {
            if (entry == null) continue;
            RoadStyle style = RoadStyles.buildStyle(entry);
            if (style == null) {
                LOGGER.warn("Skipping road style override for selectors {} due to invalid palette", entry.biomeSelectors());
                continue;
            }
            parsed.add(new ParsedStyle(entry.biomeSelectors(), style));
            if (!entry.biomeSelectors().isEmpty()) continue;
            fallback = style;
        }
        if (fallback == null) {
            fallback = RoadStyles.buildFallbackFromDefaults();
        }
        STYLES = List.copyOf(parsed);
        FALLBACK = fallback;
        VERSION.incrementAndGet();
        CACHE.clear();
    }

    private static RoadStyle buildFallbackFromDefaults() {
        RoadStyleConfigEntry defaultEntry = RoadStyleDefaults.entries().getFirst();
        RoadStyle style = RoadStyles.buildStyle(defaultEntry);
        if (style != null) {
            return style;
        }
        BlockPalette palette = BlockPalette.builder().add(class_2246.field_10219.method_9564(), 7).add(class_2246.field_10194.method_9564(), 2).add(class_2246.field_10445.method_9564(), 2).add(class_2246.field_9989.method_9564(), 1).add(class_2246.field_10255.method_9564(), 1).build();
        return new RoadStyle(palette, List.of());
    }

    private static RoadStyle buildStyle(RoadStyleConfigEntry entry) {
        BlockPalette palette = RoadStyles.buildPalette(entry.palette());
        if (palette == null) {
            return null;
        }
        List<Decoration> decorations = RoadStyles.buildDecorations(entry.decorations());
        return new RoadStyle(palette, decorations);
    }

    private static BlockPalette buildPalette(List<RoadStyleConfigEntry.SurfaceBlockEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        BlockPalette.Builder builder = BlockPalette.builder();
        int added = 0;
        for (RoadStyleConfigEntry.SurfaceBlockEntry entry : entries) {
            String raw;
            int weight;
            if (entry == null || (weight = entry.weight()) <= 0 || (raw = entry.block()) == null || raw.isBlank()) continue;
            if (raw.startsWith("#")) {
                String tagName = raw.substring(1);
                class_2960 id = class_2960.method_12829((String)tagName);
                if (id == null) {
                    LOGGER.warn("Road style palette tag '{}' is invalid", (Object)raw);
                    continue;
                }
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id);
                Optional optional = class_7923.field_41175.method_46733(tag);
                if (optional.isEmpty()) {
                    LOGGER.warn("Road style palette tag '{}' resolved to nothing", (Object)raw);
                    continue;
                }
                class_6885 list = (class_6885)optional.get();
                int before = added;
                for (class_6880 blockEntry : list) {
                    class_2248 block = (class_2248)blockEntry.comp_349();
                    builder.add(block.method_9564(), weight);
                    ++added;
                }
                if (added != before) continue;
                LOGGER.warn("Road style palette tag '{}' had no resolvable blocks", (Object)raw);
                continue;
            }
            class_2960 id = class_2960.method_12829((String)raw);
            if (id == null) {
                LOGGER.warn("Road style palette block '{}' is invalid", (Object)raw);
                continue;
            }
            Optional optional = class_7923.field_41175.method_17966(id);
            if (optional.isEmpty()) {
                LOGGER.warn("Road style palette block '{}' is not registered", (Object)raw);
                continue;
            }
            builder.add(((class_2248)optional.get()).method_9564(), weight);
            ++added;
        }
        if (added == 0) {
            return null;
        }
        return builder.build();
    }

    private static List<Decoration> buildDecorations(List<RoadStyleConfigEntry.DecorationEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return List.of();
        }
        ArrayList<FenceDecoration> list = new ArrayList<FenceDecoration>();
        block4: for (RoadStyleConfigEntry.DecorationEntry entry : entries) {
            RoadDecorationType type;
            if (entry == null || (type = entry.type()) == null) continue;
            switch (type) {
                case FENCE: {
                    class_2680 state = RoadStyles.resolveBlockState(entry.block(), "fence decoration");
                    if (state == null) continue block4;
                    list.add(new FenceDecoration(state));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    LOGGER.warn("Unknown road decoration type '{}'", (Object)type.id());
                }
            }
        }
        return list.isEmpty() ? List.of() : List.copyOf(list);
    }

    private static class_2680 resolveBlockState(String raw, String role) {
        if (raw == null || raw.isBlank()) {
            LOGGER.warn("Road style {} is empty", (Object)role);
            return null;
        }
        if (raw.startsWith("#")) {
            String tagName = raw.substring(1);
            class_2960 id = class_2960.method_12829((String)tagName);
            if (id == null) {
                LOGGER.warn("Road style {} tag '{}' is invalid", (Object)role, (Object)raw);
                return null;
            }
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id);
            Optional optional = class_7923.field_41175.method_46733(tag);
            if (optional.isEmpty()) {
                LOGGER.warn("Road style {} tag '{}' resolved to nothing", (Object)role, (Object)raw);
                return null;
            }
            class_6885 list = (class_6885)optional.get();
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                class_6880 blockEntry = (class_6880)iterator.next();
                return ((class_2248)blockEntry.comp_349()).method_9564();
            }
            LOGGER.warn("Road style {} tag '{}' had no blocks", (Object)role, (Object)raw);
            return null;
        }
        class_2960 id = class_2960.method_12829((String)raw);
        if (id == null) {
            LOGGER.warn("Road style {} '{}' is invalid", (Object)role, (Object)raw);
            return null;
        }
        Optional optional = class_7923.field_41175.method_17966(id);
        if (optional.isEmpty()) {
            LOGGER.warn("Road style {} '{}' is not registered", (Object)role, (Object)raw);
            return null;
        }
        return ((class_2248)optional.get()).method_9564();
    }

    static {
        RAConfigHolder.listen(RoadStyles::reload);
    }

    private record CacheEntry(int version, List<CompiledStyle> styles) {
    }

    private record CompiledStyle(RoadStyle style, List<class_6885<class_1959>> selectors) {
    }

    private record ParsedStyle(List<String> selectors, RoadStyle style) {
    }
}

