/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.handlers.PipelineRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadPipelineController {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadPipelineController");
    private static final Set<class_5321<class_1937>> INITIALIZED = ConcurrentHashMap.newKeySet();
    private static final int INTERVAL_TICKS = RoadArchitect.CONFIG.pipelineIntervalSeconds() * 20;
    private static final Set<class_2960> TARGET_IDS = new HashSet<class_2960>();
    private static final Set<class_6862<class_3195>> TARGET_TAGS = new HashSet<class_6862<class_3195>>();
    private static int tickCounter = 0;

    private RoadPipelineController() {
    }

    public static void register() {
        RoadPipelineController.cacheStructureSelectors();
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (world.method_27983() != class_1937.field_25179) {
                return;
            }
            class_1923 spawnChunk = new class_1923(world.method_43126());
            if (!chunk.method_12004().equals((Object)spawnChunk)) {
                return;
            }
            if (INITIALIZED.add((class_5321<class_1937>)world.method_27983())) {
                LOGGER.debug("Spawn chunk {} generated in {}, starting pipeline", (Object)chunk.method_12004(), (Object)world.method_27983().method_29177());
                PipelineRunner.runPipeline(world, world.method_43126(), PipelineRunner.PipelineMode.INIT);
            }
        });
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (world.method_27983() != class_1937.field_25179) {
                return;
            }
            if (!RoadPipelineController.containsTargetStructure(world, (class_2791)chunk)) {
                return;
            }
            LOGGER.debug("Chunk {} generated with target structure, starting pipeline", (Object)chunk.method_12004());
            PipelineRunner.runPipeline(world, chunk.method_12004().method_33943(0), PipelineRunner.PipelineMode.CHUNK);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            class_3218 world = (class_3218)player.method_37908();
            if (world.method_27983() != class_1937.field_25179) {
                return;
            }
            class_2338 pos = player.method_24515();
            LOGGER.debug("Player {} joined at {}, starting pipeline", (Object)player.method_5477().getString(), (Object)pos);
            PipelineRunner.runPipeline(world, pos, PipelineRunner.PipelineMode.PERIODIC);
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            if (++tickCounter < INTERVAL_TICKS) {
                return;
            }
            tickCounter = 0;
            for (class_3222 player : server.method_3760().method_14571()) {
                class_1937 world = player.method_37908();
                if (world.method_27983() != class_1937.field_25179) continue;
                class_2338 pos = player.method_24515();
                LOGGER.debug("Periodic trigger at player {} pos {}, starting pipeline", (Object)player.method_5477().getString(), (Object)pos);
                PipelineRunner.runPipeline((class_3218)world, pos, PipelineRunner.PipelineMode.PERIODIC);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> INITIALIZED.clear());
    }

    private static void cacheStructureSelectors() {
        TARGET_IDS.clear();
        TARGET_TAGS.clear();
        List<String> selectors = RoadArchitect.CONFIG.structureSelectors();
        for (String sel : selectors) {
            if (sel.startsWith("#")) {
                TARGET_TAGS.add((class_6862<class_3195>)class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60654((String)sel.substring(1))));
                continue;
            }
            TARGET_IDS.add(class_2960.method_60654((String)sel));
        }
    }

    private static boolean containsTargetStructure(class_3218 world, class_2791 chunk) {
        if (!chunk.method_38871()) {
            return false;
        }
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
        for (class_3449 start : chunk.method_12016().values()) {
            class_3195 structure = start.method_16656();
            class_2960 id = registry.method_10221((Object)structure);
            if (id != null && TARGET_IDS.contains(id)) {
                return true;
            }
            class_6880 entry = registry.method_47983((Object)structure);
            if (entry == null) continue;
            for (class_6862<class_3195> tag : TARGET_TAGS) {
                if (!entry.method_40220(tag)) continue;
                return true;
            }
        }
        return false;
    }
}

