/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.oxcodsnet.roadarchitect.config.RoadDecorationType;
import net.oxcodsnet.roadarchitect.config.defaults.BopRoadStyleDefaults;
import net.oxcodsnet.roadarchitect.config.defaults.LampPostDefaults;
import net.oxcodsnet.roadarchitect.config.defaults.RoadStyleDefaults;

@Config(name="roadarchitect")
public final class RoadArchitectConfigData
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public int initScanRadius = 125;
    @ConfigEntry.Gui.Tooltip
    public int chunkGenerateScanRadius = 20;
    @ConfigEntry.Gui.Tooltip
    public int maxConnectionDistance = 715;
    @ConfigEntry.Gui.Tooltip
    public int pipelineIntervalSeconds = 120;
    @ConfigEntry.Gui.Tooltip
    public int lampInterval = 30;
    @ConfigEntry.Gui.Tooltip
    public int roadWidth = 3;
    @ConfigEntry.Gui.Tooltip
    public int sideDecorationInterval = 12;
    @ConfigEntry.Gui.Tooltip
    public int buoyInterval = 18;
    @ConfigEntry.BoundedDiscrete(min=0L, max=8L)
    @ConfigEntry.Gui.Tooltip
    public int maskErosion = 1;
    @ConfigEntry.Gui.Tooltip
    public boolean deterministicDecorations = true;
    @ConfigEntry.Category(value="roadStyles")
    @ConfigEntry.Gui.TransitiveObject
    public RoadStyleSettings roadStyles = new RoadStyleSettings();
    @ConfigEntry.Category(value="bopRoadStyles")
    @ConfigEntry.Gui.TransitiveObject
    public BopRoadStyleSettings bopRoadStyles = new BopRoadStyleSettings();
    @ConfigEntry.Category(value="lampPosts")
    @ConfigEntry.Gui.TransitiveObject
    public LampPostSettings lampPosts = new LampPostSettings();
    @ConfigEntry.Gui.Tooltip
    public List<String> structureSelectors = List.of("#minecraft:village");
    @ConfigEntry.Gui.Tooltip
    public List<String> dimensionSelectors = List.of("minecraft:overworld");
    @ConfigEntry.Category(value="terrainAnalyzer")
    @ConfigEntry.Gui.TransitiveObject
    public TerrainAnalyzerSettings terrainAnalyzer = new TerrainAnalyzerSettings();
    @ConfigEntry.Category(value="cache")
    @ConfigEntry.Gui.TransitiveObject
    public CacheSection cache = new CacheSection();
    @ConfigEntry.Category(value="pathfinding")
    @ConfigEntry.Gui.TransitiveObject
    public PathfindingSettings pathfinding = new PathfindingSettings();
    @ConfigEntry.Category(value="forbiddenBiomes")
    @ConfigEntry.Gui.TransitiveObject
    public ForbiddenBiomeSettings forbiddenBiomes = new ForbiddenBiomeSettings();
    @ConfigEntry.Category(value="debug")
    @ConfigEntry.Gui.TransitiveObject
    public DebugSettings debug = new DebugSettings();

    public static final class RoadStyleSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enabled = true;
        @ConfigEntry.Gui.Tooltip
        public List<RoadStyleDefinition> overrides = RoadStyleDefaults.createDefinitionCopies();
    }

    public static final class BopRoadStyleSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enabled = true;
        @ConfigEntry.Gui.Tooltip
        public List<RoadStyleDefinition> overrides = BopRoadStyleDefaults.createDefinitionCopies();
    }

    public static final class LampPostSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enabled = true;
        @ConfigEntry.Gui.Tooltip
        public List<LampPostDefinition> overrides = LampPostDefaults.createDefinitionCopies();
    }

    public static final class TerrainAnalyzerSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enabled = false;
        @ConfigEntry.BoundedDiscrete(min=4L, max=64L)
        @ConfigEntry.Gui.Tooltip
        public int roughRadius = 12;
        @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
        @ConfigEntry.Gui.Tooltip
        public int roughStride = 3;
        @ConfigEntry.BoundedDiscrete(min=0L, max=64L)
        @ConfigEntry.Gui.Tooltip
        public int roughRangeThreshold = 12;
        @ConfigEntry.Gui.Tooltip
        public double roughPenaltyScale = 15.0;
    }

    public static final class CacheSection {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=16L, max=4096L)
        public int runtimeBudgetMb = 256;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=16L, max=1024L)
        public int snapshotBudgetMb = 64;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=16L, max=4096L)
        public int persistedBudgetMb = 128;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=4L, max=128L)
        public int regionSizeChunks = 32;
        @ConfigEntry.Gui.Tooltip
        public boolean enablePrefill = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(min=0L, max=16384L)
        public int prefillMaxChunks = 2048;
        @ConfigEntry.Gui.Tooltip
        public boolean persistHeights = true;
        @ConfigEntry.Gui.Tooltip
        public boolean persistStabilities = true;
        @ConfigEntry.Gui.Tooltip
        public boolean persistBiomes = true;
    }

    public static final class PathfindingSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean preferLandOverWater = true;
        @ConfigEntry.Gui.Tooltip
        public double waterStepPenalty = 200.0;
        @ConfigEntry.BoundedDiscrete(min=0L, max=64L)
        @ConfigEntry.Gui.Tooltip
        public int coastAvoidBufferBlocks = 16;
        @ConfigEntry.Gui.Tooltip
        public double coastProximityPenalty = 180.0;
        @ConfigEntry.Gui.Tooltip
        public boolean acceptHighProgressPartial = true;
        @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
        @ConfigEntry.Gui.Tooltip
        public int partialProgressPercent = 80;
    }

    public static final class ForbiddenBiomeSettings {
        @ConfigEntry.Gui.Tooltip
        public List<String> selectors = List.of("#minecraft:is_ocean", "#minecraft:is_deep_ocean");
        @ConfigEntry.BoundedDiscrete(min=0L, max=64L)
        @ConfigEntry.Gui.Tooltip
        public int bufferBlocks = 16;
        @ConfigEntry.Gui.Tooltip
        public double proximityPenalty = 500.0;
    }

    public static final class DebugSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean enableVerboseLogs = false;
        @ConfigEntry.Gui.Tooltip
        public boolean enablePipelineProfiler = false;
        @ConfigEntry.Gui.Tooltip
        public boolean enableCacheLogs = false;
        @ConfigEntry.Gui.Tooltip
        public boolean showCacheStatsOverlay = false;
    }

    public static final class LampPostDefinition {
        @ConfigEntry.Gui.Tooltip
        public List<String> biomeSelectors = new ArrayList<String>();
        @ConfigEntry.Gui.Tooltip
        public String baseBlock = "minecraft:cobblestone_wall";
        @ConfigEntry.Gui.Tooltip
        public String postBlock = "minecraft:oak_fence";
        @ConfigEntry.Gui.Tooltip
        public String lampBlock = "minecraft:lantern";
    }

    public static final class RoadDecorationEntry {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public RoadDecorationType type = RoadDecorationType.FENCE;
        @ConfigEntry.Gui.Tooltip
        public String block = "";
    }

    public static final class RoadPaletteEntry {
        @ConfigEntry.Gui.Tooltip
        public String block = "";
        @ConfigEntry.Gui.Tooltip
        public int weight = 1;
    }

    public static final class RoadStyleDefinition {
        @ConfigEntry.Gui.Tooltip
        public List<String> biomeSelectors = new ArrayList<String>();
        @ConfigEntry.Gui.Tooltip
        public List<RoadPaletteEntry> palette = new ArrayList<RoadPaletteEntry>();
        @ConfigEntry.Gui.Tooltip
        public List<RoadDecorationEntry> decorations = new ArrayList<RoadDecorationEntry>();
    }
}

