/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.function.IntBinaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.oxcodsnet.roadarchitect.config.RAConfig;
import net.oxcodsnet.roadarchitect.config.RAConfigHolder;
import net.oxcodsnet.roadarchitect.util.CacheManager;

public final class TerrainAnalyzer {
    private TerrainAnalyzer() {
    }

    public static double stabilityCost(ServerLevel world, int x, int z, int y) {
        int coarseRange;
        int local = 0;
        for (Direction d : Direction.Plane.HORIZONTAL) {
            int ny = CacheManager.getHeight(world, x + d.getStepX(), z + d.getStepZ());
            if ((local += Math.abs(y - ny)) <= 3) continue;
            return Double.MAX_VALUE;
        }
        double baseCost = (double)local * 16.0;
        RAConfig cfg = RAConfigHolder.get();
        if (!cfg.terrainAnalyzerEnabled()) {
            return baseCost;
        }
        int radius = Math.max(1, cfg.terrainRoughRadius());
        int stride = Math.max(1, cfg.terrainRoughStride());
        int threshold = Math.max(0, cfg.terrainRangeThreshold());
        double scale = Math.max(0.0, cfg.terrainPenaltyScale());
        IntBinaryOperator H = (ix, iz) -> CacheManager.getHeight(world, ix, iz);
        int coarseStride = Math.min(radius, stride * 2);
        int range = coarseRange = TerrainAnalyzer.heightRange(H, x, z, radius, coarseStride, threshold);
        if (coarseRange > threshold && coarseStride != stride) {
            range = TerrainAnalyzer.heightRange(H, x, z, radius, stride, threshold);
        }
        double roughPenalty = TerrainAnalyzer.roughnessPenalty(range, threshold, scale);
        return baseCost + roughPenalty;
    }

    public static int heightRange(IntBinaryOperator heightFn, int x, int z, int radius, int stride) {
        return TerrainAnalyzer.heightRange(heightFn, x, z, radius, stride, Integer.MAX_VALUE);
    }

    public static int heightRange(IntBinaryOperator heightFn, int x, int z, int radius, int stride, int earlyExitThreshold) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int exitDelta = earlyExitThreshold < 0 ? Integer.MAX_VALUE : earlyExitThreshold;
        for (int dx = -radius; dx <= radius; dx += stride) {
            for (int dz = -radius; dz <= radius; dz += stride) {
                int h = heightFn.applyAsInt(x + dx, z + dz);
                if (h < min) {
                    min = h;
                }
                if (h > max) {
                    max = h;
                }
                if (max - min <= exitDelta) continue;
                return max - min;
            }
        }
        return max - min;
    }

    public static double roughnessPenalty(int heightRange) {
        RAConfig cfg = RAConfigHolder.get();
        return TerrainAnalyzer.roughnessPenalty(heightRange, Math.max(0, cfg.terrainRangeThreshold()), Math.max(0.0, cfg.terrainPenaltyScale()));
    }

    public static double roughnessPenalty(int heightRange, int threshold, double scale) {
        if (heightRange <= threshold) {
            return 0.0;
        }
        int excess = heightRange - threshold;
        return (double)excess * scale;
    }
}

