/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class FenceDecoration
implements Decoration {
    private static final int MAX_SUPPORT_DEPTH = 3;
    private static final int MAX_UP_SEARCH = 3;
    private static final int PLACE_FLAGS = 7;
    private final BlockState fenceState;

    public FenceDecoration(BlockState fenceState) {
        this.fenceState = fenceState;
    }

    @Override
    public void place(WorldGenLevel world, BlockPos basePos, RandomSource random) {
        BlockPos top = this.computeTop(world, basePos);
        if (top == null) {
            return;
        }
        this.placeFromTopDown(world, top);
    }

    private BlockPos computeTop(WorldGenLevel world, BlockPos base) {
        int bottomY = world.getMinY();
        BlockState baseState = world.getBlockState(base);
        boolean baseSolid = baseState.isRedstoneConductor((BlockGetter)world, base);
        if (!baseSolid) {
            BlockPos probe = base.below();
            for (int depth = 0; probe.getY() >= bottomY && depth < 3 && !world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe); ++depth) {
                probe = probe.below();
            }
            if (!world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe)) {
                return null;
            }
            BlockPos top = probe.above();
            if (!world.getBlockState(top).canBeReplaced()) {
                return null;
            }
            return top;
        }
        BlockPos top = base.above();
        for (int rise = 0; rise < 3 && !world.getBlockState(top).canBeReplaced(); ++rise) {
            top = top.above();
        }
        if (!world.getBlockState(top).canBeReplaced()) {
            return null;
        }
        BlockPos probe = top.below();
        for (int depth = 0; probe.getY() >= bottomY && depth < 3 && !world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe); ++depth) {
            probe = probe.below();
        }
        if (!world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe)) {
            return null;
        }
        return top;
    }

    private void placeFromTopDown(WorldGenLevel world, BlockPos top) {
        world.setBlock(top, this.fenceState, 7);
        BlockPos cur = top.below();
        for (int depth = 0; cur.getY() >= world.getMinY() && depth < 3 && !world.getBlockState(cur).isRedstoneConductor((BlockGetter)world, cur); ++depth) {
            world.setBlock(cur, this.fenceState, 7);
            cur = cur.below();
        }
    }

    public void placeFenceStripe(WorldGenLevel world, List<BlockPos> stripe) {
        for (BlockPos base : stripe) {
            BlockPos top = this.computeTop(world, base);
            if (top == null) continue;
            this.placeFromTopDown(world, top);
        }
        for (BlockPos base : stripe) {
            for (int dy = 0; dy <= 3; ++dy) {
                BlockPos p = base.above(dy);
                BlockState st = world.getBlockState(p);
                if (!st.is(this.fenceState.getBlock())) continue;
                for (Direction d : Direction.Plane.HORIZONTAL) {
                    BlockPos n = p.relative(d);
                    st = st.updateShape((LevelReader)world, (ScheduledTickAccess)world, p, d, n, world.getBlockState(n), RandomSource.create());
                }
                world.setBlock(p, st, 7);
            }
        }
    }
}

