/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.handlers.PathFinderManager;
import net.oxcodsnet.roadarchitect.handlers.PipelineStage;
import net.oxcodsnet.roadarchitect.handlers.RoadPostProcessor;
import net.oxcodsnet.roadarchitect.handlers.StructureScanManager;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import net.oxcodsnet.roadarchitect.util.profiler.PipelineProfiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + PipelineRunner.class.getSimpleName()));
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);
    private static volatile PipelineStage currentStage = PipelineStage.SCANNING_STRUCTURES;

    private PipelineRunner() {
    }

    public static PipelineStage getCurrentStage() {
        return currentStage;
    }

    private static void setStage(PipelineStage stage) {
        currentStage = stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runPipeline(ServerLevel world, BlockPos center, PipelineMode mode) {
        block40: {
            if (!RUNNING.compareAndSet(false, true)) {
                return;
            }
            String worldId = world.dimension().location().toString();
            PipelineProfiler profiler = null;
            try {
                if (RoadArchitect.CONFIG.debugPipelineProfiler()) {
                    profiler = PipelineProfiler.start(mode.reason(), worldId, center);
                }
                PipelineProfiler.increment("pipeline.run.total");
                PipelineProfiler.increment("pipeline.run." + mode.name().toLowerCase(Locale.ROOT));
                PipelineRunner.setStage(PipelineStage.INITIALISATION);
                DebugLog.info(LOGGER, "Pipeline start: {}", mode.reason());
                switch (mode.ordinal()) {
                    case 0: {
                        PipelineRunner.setStage(PipelineStage.SCANNING_STRUCTURES);
                        try (PipelineProfiler.Section stage = PipelineProfiler.openSection("stage.structure_scan");){
                            StructureScanManager.scan(world, mode.reason(), center, RoadArchitect.CONFIG.initScanRadius());
                        }
                        PipelineRunner.setStage(PipelineStage.PATH_FINDING);
                        stage = PipelineProfiler.openSection("stage.pathfinding");
                        try {
                            PathFinderManager.computePaths(world, 1000);
                        }
                        finally {
                            if (stage != null) {
                                stage.close();
                            }
                        }
                        PipelineRunner.setStage(PipelineStage.POST_PROCESSING);
                        stage = PipelineProfiler.openSection("stage.post_processing");
                        try {
                            RoadPostProcessor.processPending(world);
                            break;
                        }
                        finally {
                            if (stage != null) {
                                stage.close();
                            }
                        }
                    }
                    default: {
                        PipelineRunner.setStage(PipelineStage.SCANNING_STRUCTURES);
                        try (PipelineProfiler.Section stage = PipelineProfiler.openSection("stage.structure_scan");){
                            StructureScanManager.scan(world, mode.reason(), center, RoadArchitect.CONFIG.chunkGenerateScanRadius());
                        }
                        PipelineRunner.setStage(PipelineStage.PATH_FINDING);
                        stage = PipelineProfiler.openSection("stage.pathfinding");
                        try {
                            PathFinderManager.computePaths(world, 50, RoadArchitect.CONFIG.maxConnectionDistance() * 5);
                            break;
                        }
                        finally {
                            if (stage != null) {
                                stage.close();
                            }
                        }
                    }
                }
                if (profiler == null) break block40;
                profiler.close();
            }
            catch (Exception e) {
                block41: {
                    try {
                        LOGGER.error("Pipeline failure", (Throwable)e);
                        if (profiler == null) break block41;
                        profiler.close();
                    }
                    catch (Throwable throwable) {
                        if (profiler != null) {
                            profiler.close();
                        }
                        PipelineRunner.setStage(PipelineStage.COMPLETE);
                        RUNNING.set(false);
                        DebugLog.info(LOGGER, "Pipeline finished: {}", mode.reason());
                        throw throwable;
                    }
                }
                PipelineRunner.setStage(PipelineStage.COMPLETE);
                RUNNING.set(false);
                DebugLog.info(LOGGER, "Pipeline finished: {}", mode.reason());
            }
        }
        PipelineRunner.setStage(PipelineStage.COMPLETE);
        RUNNING.set(false);
        DebugLog.info(LOGGER, "Pipeline finished: {}", mode.reason());
    }

    public static enum PipelineMode {
        INIT("initial_chunk"),
        CHUNK("chunk_structure_trigger"),
        PERIODIC("player_periodic_trigger");

        private final String reason;

        private PipelineMode(String reason) {
            this.reason = reason;
        }

        public String reason() {
            return this.reason;
        }
    }
}

