/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadGraphStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadGraphStateManager.class.getSimpleName()));

    private RoadGraphStateManager() {
    }

    public static void onWorldLoad(ServerLevel world) {
        RoadGraphState.get(world);
        DebugLog.info(LOGGER, "RoadGraphState loaded for world {}", world.dimension().location());
    }

    public static void onWorldUnload(ServerLevel world) {
        RoadGraphState state = RoadGraphState.get(world);
        state.setDirty();
        DebugLog.info(LOGGER, "Saved RoadGraphState for world {} on unload", world.dimension().location());
    }

    public static void onServerStopping(MinecraftServer server) {
        for (ServerLevel world : server.getAllLevels()) {
            RoadGraphState.get(world).setDirty();
        }
        DebugLog.info(LOGGER, "Server stopping, all RoadGraphStates marked dirty", new Object[0]);
    }
}

