/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge.client.hook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.InputEvent;
import net.oxcodsnet.roadarchitect.client.gui.RoadGraphDebugScreenVanilla;
import net.oxcodsnet.roadarchitect.neoforge.client.RAKeybinds;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public final class DebugGraphScreenHook {
    private DebugGraphScreenHook() {
    }

    public static void onKey(InputEvent.Key event) {
        if (RAKeybinds.OPEN == null || !RAKeybinds.OPEN.consumeClick()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen instanceof RoadGraphDebugScreenVanilla) {
            mc.setScreen(null);
            return;
        }
        if (mc.getSingleplayerServer() == null || mc.level == null) {
            return;
        }
        ArrayList<RoadGraphDebugScreenVanilla.DimensionLayer> layers = new ArrayList<RoadGraphDebugScreenVanilla.DimensionLayer>();
        for (ResourceKey key : mc.getSingleplayerServer().levelKeys()) {
            ServerLevel world = mc.getSingleplayerServer().getLevel(key);
            if (world == null) continue;
            RoadGraphState state = RoadGraphState.get(world);
            ArrayList<Node> nodes = new ArrayList<Node>(state.nodes().all().values());
            ArrayList<EdgeStorage.Edge> edges = new ArrayList<EdgeStorage.Edge>(state.edges().all().values());
            layers.add(new RoadGraphDebugScreenVanilla.DimensionLayer((ResourceKey<Level>)key, nodes, edges));
        }
        if (layers.isEmpty()) {
            return;
        }
        layers.sort(Comparator.comparing(layer -> layer.dimension().location().toString()));
        ResourceKey currentDim = mc.level.dimension();
        int idx = -1;
        for (int i = 0; i < layers.size(); ++i) {
            if (!((RoadGraphDebugScreenVanilla.DimensionLayer)layers.get(i)).dimension().equals((Object)currentDim)) continue;
            idx = i;
            break;
        }
        if (idx > 0) {
            Collections.swap(layers, 0, idx);
        }
        mc.setScreen((Screen)new RoadGraphDebugScreenVanilla(layers));
    }
}

