/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public class NodeStorage {
    private final Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();

    public static NodeStorage fromNbt(ListTag list) {
        NodeStorage storage = new NodeStorage();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.getCompound(i);
            String id = tag.getString("id");
            BlockPos pos = BlockPos.of((long)tag.getLong("pos"));
            String type = tag.getString("type");
            storage.nodes.put(id, new Node(id, pos, type));
        }
        return storage;
    }

    public Node add(BlockPos pos, String type) {
        String id = UUID.randomUUID().toString();
        Node node = new Node(id, pos, type);
        this.nodes.put(id, node);
        return node;
    }

    public boolean remove(String id) {
        return this.nodes.remove(id) != null;
    }

    public Map<String, Node> all() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public void clear() {
        this.nodes.clear();
    }

    public ListTag toNbt() {
        ListTag list = new ListTag();
        for (Node node : this.nodes.values()) {
            CompoundTag tag = new CompoundTag();
            tag.putString("id", node.id());
            tag.putLong("pos", node.pos().asLong());
            tag.putString("type", node.type());
            list.add((Object)tag);
        }
        return list;
    }
}

