/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class RoadBuilderStorage
extends SavedData {
    private static final String KEY = "road_builder_tasks";
    private static final String SEGMENTS_KEY = "segments";
    private static final String CHUNK_KEY = "chunk";
    private static final String PATH_KEY = "path";
    private static final String START_KEY = "start";
    private static final String END_KEY = "end";
    public static final SavedData.Factory<RoadBuilderStorage> TYPE = new SavedData.Factory(RoadBuilderStorage::new, RoadBuilderStorage::fromNbt, DataFixTypes.SAVED_DATA_SCOREBOARD);
    private final Map<ChunkPos, List<SegmentEntry>> segments = new ConcurrentHashMap<ChunkPos, List<SegmentEntry>>();

    public static RoadBuilderStorage get(ServerLevel world) {
        return PersistentStateUtil.get(world, TYPE, KEY);
    }

    public static RoadBuilderStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        RoadBuilderStorage storage = new RoadBuilderStorage();
        ListTag list = tag.getList(SEGMENTS_KEY, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.getCompound(i);
            ChunkPos chunk = new ChunkPos(entry.getLong(CHUNK_KEY));
            String path = entry.getString(PATH_KEY);
            int start = entry.getInt(START_KEY);
            int end = entry.getInt(END_KEY);
            storage.segments.computeIfAbsent(chunk, c -> new CopyOnWriteArrayList()).add(new SegmentEntry(path, start, end));
        }
        return storage;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag list = new ListTag();
        for (Map.Entry<ChunkPos, List<SegmentEntry>> entry : this.segments.entrySet()) {
            long pos = entry.getKey().toLong();
            for (SegmentEntry segment : entry.getValue()) {
                CompoundTag elem = new CompoundTag();
                elem.putLong(CHUNK_KEY, pos);
                elem.putString(PATH_KEY, segment.pathKey());
                elem.putInt(START_KEY, segment.start());
                elem.putInt(END_KEY, segment.end());
                list.add((Object)elem);
            }
        }
        tag.put(SEGMENTS_KEY, (Tag)list);
        return tag;
    }

    public void addSegment(ChunkPos chunk, String key, int start, int end) {
        this.segments.computeIfAbsent(chunk, c -> new CopyOnWriteArrayList()).add(new SegmentEntry(key, start, end));
        this.setDirty();
    }

    public List<SegmentEntry> getSegments(ChunkPos chunk) {
        return this.segments.getOrDefault(chunk, List.of());
    }

    public void removeSegment(ChunkPos chunk, SegmentEntry entry) {
        List<SegmentEntry> list = this.segments.get(chunk);
        if (list != null && list.remove(entry)) {
            if (list.isEmpty()) {
                this.segments.remove(chunk);
            }
            this.setDirty();
        }
    }

    public record SegmentEntry(String pathKey, int start, int end) {
    }
}

