/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.PathDecorStorage;
import net.oxcodsnet.roadarchitect.storage.PathStorage;
import net.oxcodsnet.roadarchitect.storage.RoadBuilderStorage;
import net.oxcodsnet.roadarchitect.util.PathDecorUtil;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeatureConfig;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyle;
import net.oxcodsnet.roadarchitect.worldgen.style.RoadStyles;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.BuoyDecoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.FenceDecoration;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.LampPostConfigResolver;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.LampPostDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadFeature
extends Feature<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + RoadFeature.class.getSimpleName()));
    private static final BuoyDecoration BUOY = new BuoyDecoration();
    private static final BlockState PREPARATION_BLOCK = Blocks.BEDROCK.defaultBlockState();
    private static final int PREPARATION_CLEARANCE_EXTRA = 2;
    private static final Map<Long, PreparationEntry> PREPARATION_BACKUP = new ConcurrentHashMap<Long, PreparationEntry>();
    private static final Map<Long, ColumnSnapshot> PREPARATION_COLUMNS = new ConcurrentHashMap<Long, ColumnSnapshot>();
    private static final double PIXEL_PADDING = Math.sqrt(0.5);

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    private static void buildRoadStripe(WorldGenLevel world, List<BlockPos> pts, int halfWidth, RandomSource random, RoadFeatureConfig.GenerationPhase phase) {
        boolean finalizePhase = phase == RoadFeatureConfig.GenerationPhase.FINALIZE;
        int clearanceHalfWidth = halfWidth + 2;
        Registry biomeRegistry = finalizePhase ? world.registryAccess().registryOrThrow(Registries.BIOME) : null;
        for (int i = 0; i < pts.size(); ++i) {
            BlockPos p = pts.get(i);
            int prevIdx = Math.max(0, i - 2);
            int nextIdx = Math.min(pts.size() - 1, i + 2);
            Vec3 prevPoint = Vec3.atCenterOf((Vec3i)((Vec3i)pts.get(prevIdx)));
            Vec3 nextPoint = Vec3.atCenterOf((Vec3i)((Vec3i)pts.get(nextIdx)));
            double segDx = nextPoint.x - prevPoint.x;
            double segDz = nextPoint.z - prevPoint.z;
            double segmentLengthSq = segDx * segDx + segDz * segDz;
            if (segmentLengthSq < 1.0E-6) {
                segmentLengthSq = 1.0;
                segDx = 1.0;
                segDz = 0.0;
            }
            double invLen = 1.0 / Math.sqrt(segmentLengthSq);
            Vec3 dir = new Vec3(segDx * invLen, 0.0, segDz * invLen);
            double nx = dir.x;
            double nz = dir.z;
            for (int dx = -clearanceHalfWidth; dx <= clearanceHalfWidth; ++dx) {
                for (int dz = -clearanceHalfWidth; dz <= clearanceHalfWidth; ++dz) {
                    boolean insideClearance;
                    BlockPos roadPos = p.offset(dx, 0, dz);
                    Vec3 cellCenter = Vec3.atCenterOf((Vec3i)roadPos);
                    double dist = RoadFeature.horizontalDistanceToSegment(cellCenter, prevPoint, segDx, segDz, segmentLengthSq);
                    boolean insideRoad = dist <= (double)halfWidth + PIXEL_PADDING;
                    boolean bl = insideClearance = dist <= (double)clearanceHalfWidth + PIXEL_PADDING;
                    if (!insideClearance) continue;
                    long packedPos = roadPos.asLong();
                    if (!finalizePhase) {
                        if (!RoadFeature.isNotWaterBlock(world, roadPos)) continue;
                        if (insideRoad) {
                            RoadFeature.prepareCell(world, roadPos, PreparationRole.ROAD);
                            BlockPos topPos = roadPos.above();
                            RoadFeature.prepareCell(world, topPos, PreparationRole.CAP);
                            continue;
                        }
                        RoadFeature.prepareCell(world, roadPos, PreparationRole.CLEARANCE);
                        continue;
                    }
                    if (insideRoad) {
                        BlockPos topPos;
                        long packedTop;
                        PreparationEntry topEntry;
                        if (!RoadFeature.isNotWaterBlock(world, roadPos)) continue;
                        Holder biome = world.getBiome(roadPos);
                        RoadStyle style = RoadStyles.forBiome((Registry<Biome>)biomeRegistry, (Holder<Biome>)biome);
                        BlockState roadState = style.palette().pick(random);
                        RoadFeature.placeRoad(world, roadPos, roadState);
                        PreparationEntry groundEntry = PREPARATION_BACKUP.remove(packedPos);
                        if (groundEntry != null) {
                            RoadFeature.releaseColumn(roadPos);
                        }
                        if ((topEntry = PREPARATION_BACKUP.remove(packedTop = (topPos = roadPos.above()).asLong())) != null) {
                            RoadFeature.restoreFromEntry(world, topPos, topEntry);
                            continue;
                        }
                        if (!world.getBlockState(topPos).is(PREPARATION_BLOCK.getBlock())) continue;
                        world.removeBlock(topPos, false);
                        continue;
                    }
                    PreparationEntry entry = PREPARATION_BACKUP.remove(packedPos);
                    if (entry != null) {
                        RoadFeature.restoreFromEntry(world, roadPos, entry);
                        continue;
                    }
                    if (!world.getBlockState(roadPos).is(PREPARATION_BLOCK.getBlock())) continue;
                    world.removeBlock(roadPos, false);
                }
            }
            if (!finalizePhase) continue;
            RoadStyle style = RoadStyles.forBiome((Registry<Biome>)biomeRegistry, (Holder<Biome>)world.getBiome(p));
            for (Decoration deco : style.decorations()) {
                if (deco instanceof LampPostDecoration || RoadArchitect.CONFIG.deterministicDecorations() || random.nextInt(18) != 0 || !RoadFeature.isNotWaterBlock(world, p)) continue;
                RoadFeature.decorateSide(world, p, nx, nz, halfWidth, deco, random);
            }
        }
    }

    private static void decorateSide(WorldGenLevel world, BlockPos center, double nx, double nz, int halfWidth, Decoration deco, RandomSource random) {
        int side = random.nextBoolean() ? 1 : -1;
        int sx = (int)Math.round(-nz * (double)side);
        int sz = (int)Math.round(nx * (double)side);
        int fx = (int)Math.round(nx);
        int fz = (int)Math.round(nz);
        int length = 1 + random.nextInt(3);
        if (deco instanceof FenceDecoration) {
            FenceDecoration fence = (FenceDecoration)deco;
            ArrayList<BlockPos> stripe = new ArrayList<BlockPos>();
            for (int j = 0; j < length; ++j) {
                BlockPos dpos = center.offset(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                stripe.add(dpos);
            }
            fence.placeFenceStripe(world, stripe);
        } else {
            for (int j = 0; j < length; ++j) {
                BlockPos dpos = center.offset(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                deco.place(world, dpos, random);
            }
        }
    }

    private static void placeLampDet(WorldGenLevel world, BlockPos center, double nx, double nz, int halfWidth, LampPostDecoration base, boolean leftFirst, RandomSource random) {
        Direction secondFacing;
        int sx = (int)Math.round(-nz);
        int sz = (int)Math.round(nx);
        BlockPos leftPos = center.offset(sx * (halfWidth + 1), 0, sz * (halfWidth + 1));
        BlockPos rightPos = center.offset(-sx * (halfWidth + 1), 0, -sz * (halfWidth + 1));
        Direction leftFace = RoadFeature.directionFrom(-sx, -sz);
        Direction rightFace = RoadFeature.directionFrom(sx, sz);
        BlockPos firstPos = leftFirst ? leftPos : rightPos;
        Direction firstFacing = leftFirst ? leftFace : rightFace;
        BlockPos secondPos = leftFirst ? rightPos : leftPos;
        Direction direction = secondFacing = leftFirst ? rightFace : leftFace;
        if (RoadFeature.isNotWaterBlock(world, firstPos) && base.facing(firstFacing).tryPlace(world, firstPos, random)) {
            return;
        }
        if (RoadFeature.isNotWaterBlock(world, secondPos)) {
            base.facing(secondFacing).tryPlace(world, secondPos, random);
        }
    }

    private static void placeSideDet(WorldGenLevel world, BlockPos center, double nx, double nz, int halfWidth, Decoration deco, boolean leftSide, int length, RandomSource detRandom) {
        int sideMul = leftSide ? 1 : -1;
        int sx = (int)Math.round(-nz * (double)sideMul);
        int sz = (int)Math.round(nx * (double)sideMul);
        int fx = (int)Math.round(nx);
        int fz = (int)Math.round(nz);
        if (deco instanceof FenceDecoration) {
            FenceDecoration fence = (FenceDecoration)deco;
            ArrayList<BlockPos> stripe = new ArrayList<BlockPos>();
            for (int j = 0; j < length; ++j) {
                BlockPos dpos = center.offset(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                stripe.add(dpos);
            }
            if (!stripe.isEmpty()) {
                fence.placeFenceStripe(world, stripe);
            }
        } else {
            for (int j = 0; j < length; ++j) {
                BlockPos dpos = center.offset(sx * (halfWidth + 1) + fx * j, 0, sz * (halfWidth + 1) + fz * j);
                if (!RoadFeature.isNotWaterBlock(world, dpos)) continue;
                deco.place(world, dpos, detRandom);
            }
        }
    }

    static Direction directionFrom(int dx, int dz) {
        if (dx > 0) {
            return Direction.EAST;
        }
        if (dx < 0) {
            return Direction.WEST;
        }
        if (dz > 0) {
            return Direction.SOUTH;
        }
        return Direction.NORTH;
    }

    private static void prepareCell(WorldGenLevel world, BlockPos pos, PreparationRole role) {
        long key = pos.asLong();
        BlockState currentState = world.getBlockState(pos);
        PREPARATION_BACKUP.compute(key, (k, existing) -> {
            PreparationRole mergedRole;
            boolean first = existing == null;
            BlockState original = first ? currentState : existing.originalState();
            PreparationRole preparationRole = mergedRole = first ? role : PreparationRole.merge(existing.role(), role);
            if (first) {
                RoadFeature.retainColumn(world, pos, mergedRole, original);
            }
            if (!currentState.is(PREPARATION_BLOCK.getBlock())) {
                world.setBlock(pos, PREPARATION_BLOCK, 1);
            }
            return new PreparationEntry(original, mergedRole);
        });
    }

    private static void restoreFromEntry(WorldGenLevel world, BlockPos pos, PreparationEntry entry) {
        if (entry == null) {
            return;
        }
        BlockState original = entry.originalState();
        if (original == null || original.isAir()) {
            world.removeBlock(pos, false);
        } else {
            world.setBlock(pos, original, 1);
        }
        RoadFeature.releaseColumn(pos);
    }

    private static void retainColumn(WorldGenLevel world, BlockPos pos, PreparationRole role, BlockState originalState) {
        long key = RoadFeature.columnKey(pos.getX(), pos.getZ());
        PREPARATION_COLUMNS.compute(key, (k, snapshot) -> {
            int measuredHeight = RoadFeature.measureSurfaceHeight(world, pos, originalState);
            if (snapshot == null) {
                snapshot = new ColumnSnapshot(measuredHeight, 0);
            }
            if (role != PreparationRole.CAP) {
                snapshot.height = Math.max(snapshot.height, measuredHeight);
            }
            ++snapshot.count;
            return snapshot;
        });
    }

    private static void releaseColumn(BlockPos pos) {
        long key = RoadFeature.columnKey(pos.getX(), pos.getZ());
        PREPARATION_COLUMNS.computeIfPresent(key, (k, snapshot) -> {
            --snapshot.count;
            if (snapshot.count <= 0) {
                return null;
            }
            return snapshot;
        });
    }

    private static int measureSurfaceHeight(WorldGenLevel world, BlockPos pos, BlockState originalState) {
        if (originalState != null && !originalState.isAir()) {
            return pos.getY();
        }
        BlockPos.MutableBlockPos mutable = pos.mutable();
        int bottom = world.getMinBuildHeight();
        while (mutable.getY() >= bottom) {
            BlockState state = world.getBlockState((BlockPos)mutable);
            if (!state.isAir()) {
                return mutable.getY();
            }
            mutable.move(Direction.DOWN);
        }
        return pos.getY();
    }

    private static long columnKey(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static OptionalInt lookupPreparedSurface(int x, int z) {
        ColumnSnapshot snapshot = PREPARATION_COLUMNS.get(RoadFeature.columnKey(x, z));
        if (snapshot == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(snapshot.height);
    }

    private static double horizontalDistanceToSegment(Vec3 point, Vec3 start, double segDx, double segDz, double segmentLengthSq) {
        double px = point.x;
        double pz = point.z;
        double ax = start.x;
        double az = start.z;
        if (segmentLengthSq <= 1.0E-6) {
            double dx = px - ax;
            double dz = pz - az;
            return Math.sqrt(dx * dx + dz * dz);
        }
        double t = Mth.clamp((double)(((px - ax) * segDx + (pz - az) * segDz) / segmentLengthSq), (double)0.0, (double)1.0);
        double closestX = ax + segDx * t;
        double closestZ = az + segDz * t;
        double dx = px - closestX;
        double dz = pz - closestZ;
        return Math.sqrt(dx * dx + dz * dz);
    }

    private static void placeRoad(WorldGenLevel world, BlockPos pos, BlockState stateRoad) {
        if (!RoadFeature.isNotWaterBlock(world, pos)) {
            return;
        }
        world.setBlock(pos, stateRoad, 1);
    }

    private static boolean isNotWaterBlock(WorldGenLevel world, BlockPos pos) {
        int cz;
        int cx = pos.getX() >> 4;
        if (!world.hasChunk(cx, cz = pos.getZ() >> 4)) {
            return true;
        }
        return !world.getBlockState(pos).getFluidState().is(FluidTags.WATER);
    }

    private static List<BlockPos> collectLandPoints(WorldGenLevel world, List<BlockPos> pts, int from, int to) {
        int n = pts.size();
        int extFrom = Math.max(0, from - 1);
        int extTo = Math.min(n, to + 1);
        boolean[] landMask = new boolean[extTo - extFrom];
        for (int i = extFrom; i < extTo; ++i) {
            landMask[i - extFrom] = RoadFeature.isNotWaterBlock(world, pts.get(i));
        }
        ArrayList<BlockPos> out = new ArrayList<BlockPos>(Math.max(0, to - from));
        for (int i = from; i < to; ++i) {
            boolean rightLand;
            int k = i - extFrom;
            if (!landMask[k]) continue;
            boolean leftLand = k - 1 >= 0 && landMask[k - 1];
            boolean bl = rightLand = k + 1 < landMask.length && landMask[k + 1];
            if (!leftLand || !rightLand) continue;
            out.add(pts.get(i));
        }
        return out;
    }

    public boolean place(FeaturePlaceContext<RoadFeatureConfig> ctx) {
        ServerLevel serverWorld = ctx.level().getLevel();
        if (serverWorld == null) {
            return false;
        }
        WorldGenLevel world = ctx.level();
        ChunkPos chunk = new ChunkPos(ctx.origin());
        RoadBuilderStorage builder = RoadBuilderStorage.get(serverWorld);
        PathStorage paths = PathStorage.get(serverWorld);
        PathDecorStorage decor = PathDecorStorage.get(serverWorld);
        ArrayList<RoadBuilderStorage.SegmentEntry> queue = new ArrayList<RoadBuilderStorage.SegmentEntry>(builder.getSegments(chunk));
        if (queue.isEmpty()) {
            return false;
        }
        int orthWidth = Math.max(1, RoadArchitect.CONFIG.roadWidth());
        if ((orthWidth & 1) == 0) {
            --orthWidth;
        }
        int halfWidth = Math.max(0, orthWidth / 2);
        RandomSource random = world.getRandom();
        RoadFeatureConfig.GenerationPhase phase = ((RoadFeatureConfig)ctx.config()).phase();
        boolean finalizePhase = phase == RoadFeatureConfig.GenerationPhase.FINALIZE;
        Registry biomeRegistry = world.registryAccess().registryOrThrow(Registries.BIOME);
        boolean placedAny = false;
        for (RoadBuilderStorage.SegmentEntry entry : queue) {
            double nz;
            double nx;
            Vec3 dir;
            int nextIdx;
            int prevIdx;
            BlockPos p;
            int i;
            byte[] landMask;
            List<PathDecorUtil.Marker> marks;
            String[] ids = entry.pathKey().split("\\|", 2);
            if (ids.length != 2) {
                LOGGER.warn("Malformed path key '{}'; skipping", (Object)entry.pathKey());
                builder.removeSegment(chunk, entry);
                continue;
            }
            List<BlockPos> pts = paths.getPath(ids[0], ids[1]);
            if (pts.isEmpty()) {
                builder.removeSegment(chunk, entry);
                continue;
            }
            int from = Math.max(0, entry.start());
            int to = Math.min(pts.size(), entry.end());
            String pathKey = entry.pathKey();
            double[] S = PathDecorUtil.ensurePrefix(decor, pathKey, pts);
            int erosion = Math.max(0, RoadArchitect.CONFIG.maskErosion());
            int buoyInterval = Math.max(0, RoadArchitect.CONFIG.buoyInterval());
            int lampInterval = Math.max(0, RoadArchitect.CONFIG.lampInterval());
            int sideInterval = Math.max(0, RoadArchitect.CONFIG.sideDecorationInterval());
            boolean det = RoadArchitect.CONFIG.deterministicDecorations();
            PathDecorUtil.fillGroundMask(decor, pathKey, world, pts, from, to);
            PathDecorUtil.fillWaterInteriorMask(decor, pathKey, world, pts, from, to);
            if (finalizePhase && det && buoyInterval > 0) {
                int markerPhase = PathDecorUtil.phaseFor(pathKey, buoyInterval);
                List<PathDecorUtil.Marker> marks2 = PathDecorUtil.markersInWindow(S, from, to, buoyInterval, markerPhase);
                byte[] waterMask = decor.getWaterInteriorMask(pathKey);
                for (PathDecorUtil.Marker m : marks2) {
                    int idx = m.index();
                    if (!PathDecorUtil.erodedAccept(waterMask, idx, erosion, (byte)1)) continue;
                    BUOY.place(world, pts.get(idx), random);
                }
            }
            List<BlockPos> landPts = RoadFeature.collectLandPoints(world, pts, from, to);
            RoadFeature.buildRoadStripe(world, landPts, halfWidth, random, phase);
            placedAny = true;
            if (!finalizePhase) continue;
            if (det && lampInterval > 0) {
                int markerPhase = PathDecorUtil.phaseFor(pathKey, lampInterval);
                marks = PathDecorUtil.markersInWindow(S, from, to, lampInterval, markerPhase);
                landMask = decor.getGroundMask(pathKey);
                for (PathDecorUtil.Marker m : marks) {
                    i = m.index();
                    p = pts.get(i);
                    if (!PathDecorUtil.erodedAccept(landMask, i, erosion, (byte)1)) continue;
                    prevIdx = Math.max(0, i - 2);
                    nextIdx = Math.min(pts.size() - 1, i + 2);
                    dir = new Vec3((double)(pts.get(nextIdx).getX() - pts.get(prevIdx).getX()), 0.0, (double)(pts.get(nextIdx).getZ() - pts.get(prevIdx).getZ())).normalize();
                    nx = dir.x;
                    nz = dir.z;
                    boolean leftFirst = PathDecorUtil.detBool(pathKey, m.k());
                    Holder biomeAtP = world.getBiome(p);
                    LampPostDecoration resolved = LampPostConfigResolver.resolve(world, (Holder<Biome>)biomeAtP, null, pathKey, m.k());
                    if (resolved == null) continue;
                    RoadFeature.placeLampDet(world, p, nx, nz, halfWidth, resolved, leftFirst, random);
                }
            }
            if (!det || sideInterval <= 0) continue;
            int markerPhase = PathDecorUtil.phaseFor(pathKey, sideInterval);
            marks = PathDecorUtil.markersInWindow(S, from, to, sideInterval, markerPhase);
            landMask = decor.getGroundMask(pathKey);
            for (PathDecorUtil.Marker m : marks) {
                i = m.index();
                if (!PathDecorUtil.erodedAccept(landMask, i, erosion, (byte)1)) continue;
                p = pts.get(i);
                prevIdx = Math.max(0, i - 2);
                nextIdx = Math.min(pts.size() - 1, i + 2);
                dir = new Vec3((double)(pts.get(nextIdx).getX() - pts.get(prevIdx).getX()), 0.0, (double)(pts.get(nextIdx).getZ() - pts.get(prevIdx).getZ())).normalize();
                nx = dir.x;
                nz = dir.z;
                RoadStyle styleAtP = RoadStyles.forBiome((Registry<Biome>)biomeRegistry, (Holder<Biome>)world.getBiome(p));
                ArrayList<Decoration> sideDecos = new ArrayList<Decoration>();
                for (Decoration d : styleAtP.decorations()) {
                    if (d instanceof LampPostDecoration) continue;
                    sideDecos.add(d);
                }
                if (sideDecos.isEmpty()) continue;
                int choice = PathDecorUtil.detInt(pathKey, m.k(), sideDecos.size());
                Decoration chosen = (Decoration)sideDecos.get(choice);
                boolean leftSide = PathDecorUtil.detBool(pathKey, m.k());
                int length = 1 + PathDecorUtil.detInt(pathKey, m.k() ^ 0x55AA55AAL, 3);
                RoadFeature.placeSideDet(world, p, nx, nz, halfWidth, chosen, leftSide, length, RandomSource.create((long)(m.k() ^ (long)pathKey.hashCode())));
            }
        }
        return placedAny;
    }

    private static enum PreparationRole {
        CLEARANCE(0),
        ROAD(1),
        CAP(2);

        private final int priority;

        private PreparationRole(int priority) {
            this.priority = priority;
        }

        static PreparationRole merge(PreparationRole a, PreparationRole b) {
            return a.priority >= b.priority ? a : b;
        }
    }

    private record PreparationEntry(BlockState originalState, PreparationRole role) {
    }

    private static final class ColumnSnapshot {
        int height;
        int count;

        ColumnSnapshot(int height, int count) {
            this.height = height;
            this.count = count;
        }
    }
}

