/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public final class BlockPalette {
    private final List<Entry> entries;
    private final int totalWeight;

    private BlockPalette(List<Entry> entries, int totalWeight) {
        this.entries = entries;
        this.totalWeight = totalWeight;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BlockState pick(RandomSource random) {
        int r = random.nextInt(this.totalWeight);
        for (Entry e : this.entries) {
            if (r < e.weight) {
                return e.state;
            }
            r -= e.weight;
        }
        return this.entries.getFirst().state;
    }

    public static final class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int totalWeight;

        public Builder add(BlockState state, int weight) {
            this.entries.add(new Entry(state, weight));
            this.totalWeight += weight;
            return this;
        }

        public BlockPalette build() {
            return new BlockPalette(List.copyOf(this.entries), this.totalWeight);
        }
    }

    private record Entry(BlockState state, int weight) {
    }
}

