/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class LampPostDecoration
implements Decoration {
    private static final int PLACE_FLAGS = 7;
    private static final int MAX_SUPPORT_DEPTH = 3;
    private static final int MAX_UP_SEARCH = 3;
    private static final int HEIGHT = 3;
    private final BlockState baseState;
    private final BlockState postState;
    private final BlockState lampState;
    private final Direction facing;

    public LampPostDecoration(BlockState baseState, BlockState postState, BlockState lampState) {
        this(baseState, postState, lampState, Direction.NORTH);
    }

    private LampPostDecoration(BlockState baseState, BlockState postState, BlockState lampState, Direction facing) {
        this.baseState = baseState;
        this.postState = postState;
        this.lampState = lampState;
        this.facing = facing;
    }

    public LampPostDecoration facing(Direction facing) {
        return new LampPostDecoration(this.baseState, this.postState, this.lampState, facing);
    }

    @Override
    public void place(WorldGenLevel world, BlockPos basePos, RandomSource random) {
        this.tryPlace(world, basePos, random);
    }

    public boolean tryPlace(WorldGenLevel world, BlockPos basePos, RandomSource random) {
        BlockPos top = this.computeTop(world, basePos);
        if (top == null) {
            return false;
        }
        for (int i = 1; i <= 3; ++i) {
            if (world.getBlockState(top.above(i)).canBeReplaced()) continue;
            return false;
        }
        BlockPos armBase = top.above(3);
        BlockPos hook = armBase.relative(this.facing);
        if (!world.getBlockState(hook).canBeReplaced()) {
            return false;
        }
        BlockPos lantern = hook.below();
        if (!world.getBlockState(lantern).canBeReplaced()) {
            return false;
        }
        this.placeSupport(world, top);
        for (int i = 1; i < 3; ++i) {
            world.setBlock(top.above(i), this.postState, 7);
        }
        BlockState armBaseState = LampPostDecoration.withFenceConnection(this.postState, this.facing);
        world.setBlock(armBase, armBaseState, 7);
        BlockState hookState = LampPostDecoration.withFenceConnection(this.postState, this.facing.getOpposite());
        world.setBlock(hook, hookState, 7);
        BlockState ls = this.lampState;
        if (ls.hasProperty((Property)LanternBlock.HANGING)) {
            ls = (BlockState)ls.setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true));
        }
        world.setBlock(lantern, ls, 7);
        return true;
    }

    private static BlockState withFenceConnection(BlockState state, Direction dir) {
        EnumProperty wallProp;
        BooleanProperty fenceProp;
        switch (dir) {
            case NORTH: {
                BooleanProperty booleanProperty = BlockStateProperties.NORTH;
                break;
            }
            case SOUTH: {
                BooleanProperty booleanProperty = BlockStateProperties.SOUTH;
                break;
            }
            case EAST: {
                BooleanProperty booleanProperty = BlockStateProperties.EAST;
                break;
            }
            case WEST: {
                BooleanProperty booleanProperty = BlockStateProperties.WEST;
                break;
            }
            default: {
                BooleanProperty booleanProperty = fenceProp = null;
            }
        }
        if (fenceProp != null && state.hasProperty((Property)fenceProp)) {
            return (BlockState)state.setValue((Property)fenceProp, (Comparable)Boolean.valueOf(true));
        }
        switch (dir) {
            case NORTH: {
                EnumProperty enumProperty = BlockStateProperties.NORTH_WALL;
                break;
            }
            case SOUTH: {
                EnumProperty enumProperty = BlockStateProperties.SOUTH_WALL;
                break;
            }
            case EAST: {
                EnumProperty enumProperty = BlockStateProperties.EAST_WALL;
                break;
            }
            case WEST: {
                EnumProperty enumProperty = BlockStateProperties.WEST_WALL;
                break;
            }
            default: {
                EnumProperty enumProperty = wallProp = null;
            }
        }
        if (wallProp != null && state.hasProperty((Property)wallProp)) {
            return (BlockState)state.setValue((Property)wallProp, (Comparable)WallSide.LOW);
        }
        return state;
    }

    private void placeSupport(WorldGenLevel world, BlockPos top) {
        world.setBlock(top, this.baseState, 7);
        BlockPos cur = top.below();
        for (int depth = 0; cur.getY() >= world.getMinBuildHeight() && depth < 3 && !world.getBlockState(cur).isRedstoneConductor((BlockGetter)world, cur); ++depth) {
            world.setBlock(cur, this.baseState, 7);
            cur = cur.below();
        }
    }

    private BlockPos computeTop(WorldGenLevel world, BlockPos base) {
        int bottomY = world.getMinBuildHeight();
        boolean baseSolid = world.getBlockState(base).isRedstoneConductor((BlockGetter)world, base);
        if (!baseSolid) {
            BlockPos probe = base.below();
            for (int depth = 0; probe.getY() >= bottomY && depth < 3 && !world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe); ++depth) {
                probe = probe.below();
            }
            if (!world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe)) {
                return null;
            }
            return probe.above();
        }
        BlockPos top = base.above();
        for (int rise = 0; rise < 3 && !world.getBlockState(top).canBeReplaced(); ++rise) {
            top = top.above();
        }
        if (!world.getBlockState(top).canBeReplaced()) {
            return null;
        }
        BlockPos probe = top.below();
        for (int depth = 0; probe.getY() >= bottomY && depth < 3 && !world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe); ++depth) {
            probe = probe.below();
        }
        if (!world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe)) {
            return null;
        }
        return top;
    }
}

