/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadGraphStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadGraphStateManager");

    public static void register() {
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (!world.method_8608()) {
                RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
                LOGGER.debug("RoadGraphState loaded for world {}", (Object)world.method_27983().method_29177());
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (!world.method_8608()) {
                RoadGraphState state = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
                state.method_80();
                LOGGER.debug("Saved RoadGraphState for world {} on unload", (Object)world.method_27983().method_29177());
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            for (class_3218 world : server.method_3738()) {
                RoadGraphState state = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
                state.method_80();
            }
            LOGGER.debug("Server stopping, all RoadGraphStates marked dirty");
        });
    }
}

