/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.client.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerPlayer;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public class RoadGraphDebugScreenVanilla
extends Screen {
    private static final int RADIUS = 4;
    private static final int PADDING = 20;
    private static final int TARGET_GRID_PX = 80;
    private final List<Node> nodes;
    private final Collection<EdgeStorage.Edge> edges;
    private final Supplier<Component> titleSupplier;
    private final Map<String, ScreenPos> screenPositions = new HashMap<String, ScreenPos>();
    private final Map<String, Integer> typeColors = new HashMap<String, Integer>();
    private final Map<EdgeStorage.Status, Integer> statusColors = Map.of(EdgeStorage.Status.NEW, -865972, EdgeStorage.Status.SUCCESS, -14176672, EdgeStorage.Status.FAILURE, -5368277);
    private boolean dragging = false;
    private boolean firstLayout = true;
    private double zoom = 1.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;

    public RoadGraphDebugScreenVanilla(List<Node> nodes, Collection<EdgeStorage.Edge> edges) {
        this(nodes, edges, () -> Component.literal((String)"Road Graph Debug"));
    }

    public RoadGraphDebugScreenVanilla(List<Node> nodes, Collection<EdgeStorage.Edge> edges, Supplier<Component> titleSupplier) {
        super(titleSupplier.get());
        this.nodes = nodes;
        this.edges = edges;
        this.titleSupplier = titleSupplier;
        if (!nodes.isEmpty()) {
            this.minX = nodes.stream().mapToInt(n -> n.pos().getX()).min().orElse(0);
            this.maxX = nodes.stream().mapToInt(n -> n.pos().getX()).max().orElse(0);
            this.minZ = nodes.stream().mapToInt(n -> n.pos().getZ()).min().orElse(0);
            this.maxZ = nodes.stream().mapToInt(n -> n.pos().getZ()).max().orElse(0);
        }
        for (Node node : nodes) {
            this.typeColors.computeIfAbsent(node.type(), t -> RoadGraphDebugScreenVanilla.hsvToArgb(Math.abs(t.hashCode() % 360), 0.6f, 0.9f));
        }
    }

    public void render(GuiGraphics ctx, int mouseX, int mouseY, float delta) {
        this.computeLayout();
        ctx.fill(20, 20, this.width - 20, this.height - 20, -1609560048);
        ctx.renderOutline(20, 20, this.width - 40, this.height - 40, -1);
        this.drawGrid(ctx);
        for (EdgeStorage.Edge edge : this.edges) {
            ScreenPos a = this.screenPositions.get(edge.nodeA());
            ScreenPos b = this.screenPositions.get(edge.nodeB());
            if (a == null || b == null) continue;
            int col = this.statusColors.getOrDefault((Object)edge.status(), -1);
            RoadGraphDebugScreenVanilla.drawLine(ctx, a.x, a.y, b.x, b.y, col);
        }
        Node hovered = null;
        for (Node n : this.nodes) {
            ScreenPos p = this.screenPositions.get(n.id());
            if (p == null) continue;
            int fill = this.typeColors.getOrDefault(n.type(), -1);
            RoadGraphDebugScreenVanilla.fillCircle(ctx, p.x, p.y, 4, fill);
            RoadGraphDebugScreenVanilla.drawCircleOutline(ctx, p.x, p.y, 4, -16777216);
            if (!(RoadGraphDebugScreenVanilla.dist2(p.x, p.y, mouseX, mouseY) <= 16.0)) continue;
            hovered = n;
        }
        if (hovered != null) {
            Font font = Minecraft.getInstance().font;
            ctx.renderTooltip(font, (Component)Component.literal((String)(hovered.pos().toShortString() + " \u2022 " + hovered.type())), mouseX, mouseY);
        }
        this.drawScale(ctx);
        this.drawLegend(ctx);
        this.drawCenteredTitle(ctx);
        super.render(ctx, mouseX, mouseY, delta);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    protected void renderBlurredBackground(float delta) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        Node clicked = this.findClickedNode(mouseX, mouseY);
        if (clicked != null) {
            this.teleportTo(clicked);
            return true;
        }
        this.dragging = true;
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.offsetX += deltaX;
            this.offsetY += deltaY;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontal, double vertical) {
        double old = this.zoom;
        this.zoom = vertical > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        return true;
    }

    private void drawCenteredTitle(GuiGraphics ctx) {
        Font font = Minecraft.getInstance().font;
        Component t = this.titleSupplier.get();
        int tw = font.width((FormattedText)t);
        ctx.drawString(font, t, (this.width - tw) / 2, 8, -1, true);
    }

    private void drawGrid(GuiGraphics ctx) {
        int w = this.width - 40;
        int h = this.height - 40;
        double worldX0 = (double)this.minX + -this.offsetX / (this.baseScale * this.zoom);
        double worldZ0 = (double)this.minZ + -this.offsetY / (this.baseScale * this.zoom);
        double worldX1 = (double)this.minX + ((double)w - this.offsetX) / (this.baseScale * this.zoom);
        double worldZ1 = (double)this.minZ + ((double)h - this.offsetY) / (this.baseScale * this.zoom);
        int spacing = this.computeGridSpacing();
        int startWX = (int)Math.floor(worldX0 / (double)spacing) * spacing;
        int startWZ = (int)Math.floor(worldZ0 / (double)spacing) * spacing;
        int x = startWX;
        while ((double)x <= worldX1) {
            int sx = 20 + (int)(((double)x - worldX0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillV(ctx, sx, 20, 20 + h, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(x), sx + 2, 22);
            x += spacing;
        }
        int z = startWZ;
        while ((double)z <= worldZ1) {
            int sz = 20 + (int)(((double)z - worldZ0) * this.baseScale * this.zoom);
            RoadGraphDebugScreenVanilla.fillH(ctx, 20, 20 + w, sz, 0x60444444);
            this.drawSmallLabel(ctx, String.valueOf(z), 22, sz + 2);
            z += spacing;
        }
    }

    private void drawScale(GuiGraphics ctx) {
        int spacing = this.computeGridSpacing();
        int lengthPx = (int)((double)spacing * this.baseScale * this.zoom);
        int x = this.width - 20 - lengthPx - 10;
        int y = this.height - 20 - 8;
        RoadGraphDebugScreenVanilla.fillH(ctx, x, x + lengthPx, y, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x, y - 3, y + 3, -1);
        RoadGraphDebugScreenVanilla.fillV(ctx, x + lengthPx, y - 3, y + 3, -1);
        this.drawSmallLabel(ctx, spacing + "m", x, y - 10);
    }

    private void drawLegend(GuiGraphics ctx) {
        int x = 20;
        int y = this.height - 20 - this.typeColors.size() * 12;
        for (Map.Entry<String, Integer> e : this.typeColors.entrySet()) {
            ctx.fill(x, y, x + 8, y + 8, e.getValue().intValue());
            ctx.renderOutline(x, y, 8, 8, -1);
            this.drawSmallLabel(ctx, e.getKey(), x + 10, y);
            y += 12;
        }
    }

    private void computeLayout() {
        if (this.nodes.isEmpty()) {
            return;
        }
        int w = Math.max(1, this.width - 40);
        int h = Math.max(1, this.height - 40);
        double scaleX = (double)w / (double)Math.max(1, this.maxX - this.minX);
        double scaleZ = (double)h / (double)Math.max(1, this.maxZ - this.minZ);
        this.baseScale = Math.min(scaleX, scaleZ);
        if (this.firstLayout) {
            double graphW = (double)(this.maxX - this.minX) * this.baseScale * this.zoom;
            double graphH = (double)(this.maxZ - this.minZ) * this.baseScale * this.zoom;
            this.offsetX = ((double)w - graphW) / 2.0;
            this.offsetY = ((double)h - graphH) / 2.0;
            this.firstLayout = false;
        }
        this.screenPositions.clear();
        for (Node node : this.nodes) {
            double sx = (double)(node.pos().getX() - this.minX) * this.baseScale * this.zoom + this.offsetX;
            double sy = (double)(node.pos().getZ() - this.minZ) * this.baseScale * this.zoom + this.offsetY;
            this.screenPositions.put(node.id(), new ScreenPos(20 + (int)sx, 20 + (int)sy));
        }
    }

    private int computeGridSpacing() {
        double unitsPerPixel = 1.0 / (this.baseScale * this.zoom);
        double raw = 80.0 * unitsPerPixel;
        double pow10 = Math.pow(10.0, Math.floor(Math.log10(raw)));
        for (int n : new int[]{1, 2, 5}) {
            double candidate = (double)n * pow10;
            if (!(candidate >= raw)) continue;
            return (int)candidate;
        }
        return (int)(10.0 * pow10);
    }

    private Node findClickedNode(double mouseX, double mouseY) {
        for (Node node : this.nodes) {
            ScreenPos p = this.screenPositions.get(node.id());
            if (p == null || !(RoadGraphDebugScreenVanilla.dist2(p.x, p.y, mouseX, mouseY) <= 16.0)) continue;
            return node;
        }
        return null;
    }

    private void teleportTo(Node node) {
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> {
            ServerPlayer sp;
            if (mc.getSingleplayerServer() != null && mc.player != null && (sp = mc.getSingleplayerServer().getPlayerList().getPlayer(mc.player.getUUID())) != null) {
                sp.teleportTo((double)node.pos().getX() + 0.5, (double)node.pos().getY(), (double)node.pos().getZ() + 0.5);
            }
        });
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private void drawSmallLabel(GuiGraphics ctx, String s, int x, int y) {
        Font font = Minecraft.getInstance().font;
        ctx.drawString(font, (Component)Component.literal((String)s), x, y, -1, true);
    }

    private static void fillH(GuiGraphics ctx, int x0, int x1, int y, int argb) {
        if (x1 < x0) {
            int t = x0;
            x0 = x1;
            x1 = t;
        }
        ctx.fill(x0, y, x1, y + 1, argb);
    }

    private static void fillV(GuiGraphics ctx, int x, int y0, int y1, int argb) {
        if (y1 < y0) {
            int t = y0;
            y0 = y1;
            y1 = t;
        }
        ctx.fill(x, y0, x + 1, y1, argb);
    }

    private static void drawLine(GuiGraphics ctx, int x0, int y0, int x1, int y1, int argb) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            ctx.fill(x, y, x + 1, y + 1, argb);
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private static void fillCircle(GuiGraphics ctx, int cx, int cy, int r, int argb) {
        for (int dy = -r; dy <= r; ++dy) {
            int span = (int)Math.round(Math.sqrt(r * r - dy * dy));
            ctx.fill(cx - span, cy + dy, cx + span + 1, cy + dy + 1, argb);
        }
    }

    private static void drawCircleOutline(GuiGraphics ctx, int cx, int cy, int r, int argb) {
        int x = r;
        int y = 0;
        int err = 0;
        while (x >= y) {
            RoadGraphDebugScreenVanilla.plot8(ctx, cx, cy, x, y, argb);
            ++y;
            if (err <= 0) {
                err += 2 * y + 1;
            }
            if (err <= 0) continue;
            err -= 2 * --x + 1;
        }
    }

    private static void plot8(GuiGraphics ctx, int cx, int cy, int x, int y, int argb) {
        ctx.fill(cx + x, cy + y, cx + x + 1, cy + y + 1, argb);
        ctx.fill(cx + y, cy + x, cx + y + 1, cy + x + 1, argb);
        ctx.fill(cx - y, cy + x, cx - y + 1, cy + x + 1, argb);
        ctx.fill(cx - x, cy + y, cx - x + 1, cy + y + 1, argb);
        ctx.fill(cx - x, cy - y, cx - x + 1, cy - y + 1, argb);
        ctx.fill(cx - y, cy - x, cx - y + 1, cy - x + 1, argb);
        ctx.fill(cx + y, cy - x, cx + y + 1, cy - x + 1, argb);
        ctx.fill(cx + x, cy - y, cx + x + 1, cy - y + 1, argb);
    }

    private static int hsvToArgb(float hDeg, float s, float v) {
        float h = (hDeg % 360.0f + 360.0f) % 360.0f / 60.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            case -1: 
            case 5: {
                r = v;
                g = p;
                b = q;
            }
        }
        int ri = Math.round(r * 255.0f);
        int gi = Math.round(g * 255.0f);
        int bi = Math.round(b * 255.0f);
        return 0xFF000000 | ri << 16 | gi << 8 | bi;
    }

    private record ScreenPos(int x, int y) {
    }
}

