/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.config;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.oxcodsnet.roadarchitect.config.RAConfig;

public final class RAConfigHolder {
    private static final CopyOnWriteArrayList<Consumer<RAConfig>> LISTENERS = new CopyOnWriteArrayList();
    private static volatile RAConfig INSTANCE = new Defaults();

    private RAConfigHolder() {
    }

    public static RAConfig get() {
        return INSTANCE;
    }

    public static void set(RAConfig impl) {
        INSTANCE = Objects.requireNonNull(impl, "impl");
        for (Consumer<RAConfig> l : LISTENERS) {
            l.accept(INSTANCE);
        }
    }

    public static AutoCloseable listen(Consumer<RAConfig> listener) {
        LISTENERS.add(Objects.requireNonNull(listener));
        listener.accept(INSTANCE);
        return () -> LISTENERS.remove(listener);
    }

    private static final class Defaults
    implements RAConfig {
        private Defaults() {
        }

        @Override
        public int initScanRadius() {
            return 125;
        }

        @Override
        public int chunkGenerateScanRadius() {
            return 20;
        }

        @Override
        public int maxConnectionDistance() {
            return 715;
        }

        @Override
        public int pipelineIntervalSeconds() {
            return 120;
        }

        @Override
        public List<String> structureSelectors() {
            return List.of("#minecraft:village");
        }
    }
}

