/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.handlers;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadGraphStateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadGraphStateManager");

    private RoadGraphStateManager() {
    }

    public static void onWorldLoad(ServerLevel world) {
        RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
        LOGGER.debug("RoadGraphState loaded for world {}", (Object)world.dimension().location());
    }

    public static void onWorldUnload(ServerLevel world) {
        RoadGraphState state = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
        state.setDirty();
        LOGGER.debug("Saved RoadGraphState for world {} on unload", (Object)world.dimension().location());
    }

    public static void onServerStopping(MinecraftServer server) {
        for (ServerLevel world : server.getAllLevels()) {
            RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance()).setDirty();
        }
        LOGGER.debug("Server stopping, all RoadGraphStates marked dirty");
    }
}

