/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadGraphStateNeoForgeEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/RoadGraphStateEvents");

    private RoadGraphStateNeoForgeEvents() {
    }

    public static void register() {
        NeoForge.EVENT_BUS.register(RoadGraphStateNeoForgeEvents.class);
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
            LOGGER.debug("RoadGraphState loaded for world {}", (Object)world.dimension().location());
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            RoadGraphState state = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
            state.setDirty();
            LOGGER.debug("Saved RoadGraphState for world {} on unload", (Object)world.dimension().location());
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        for (ServerLevel world : event.getServer().getAllLevels()) {
            RoadGraphState state = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
            state.setDirty();
        }
        LOGGER.debug("Server stopping, all RoadGraphStates marked dirty");
    }
}

