/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.oxcodsnet.roadarchitect.storage.CacheStorage;
import net.oxcodsnet.roadarchitect.util.AsyncExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + CacheManager.class.getSimpleName()));
    private static final Map<ResourceKey<Level>, CacheStorage> STATES = new ConcurrentHashMap<ResourceKey<Level>, CacheStorage>();

    private CacheManager() {
    }

    public static void onWorldLoad(ServerLevel world) {
        if (world.isClientSide()) {
            return;
        }
        CacheManager.load(world);
    }

    public static void onWorldUnload(ServerLevel world) {
        if (world.isClientSide()) {
            return;
        }
        CacheManager.save(world);
    }

    public static void onServerStopping(MinecraftServer server) {
        for (ServerLevel world : server.getAllLevels()) {
            CacheManager.save(world);
        }
    }

    private static CacheStorage state(ServerLevel world) {
        return STATES.computeIfAbsent((ResourceKey<Level>)world.dimension(), k -> CacheStorage.get(world));
    }

    private static void load(ServerLevel world) {
        CacheStorage storage = CacheStorage.get(world);
        STATES.put((ResourceKey<Level>)world.dimension(), storage);
        LOGGER.debug("Cache loaded for world {}", (Object)world.dimension().location());
    }

    private static void save(ServerLevel world) {
        CacheStorage storage = STATES.remove(world.dimension());
        if (storage != null) {
            storage.setDirty();
            LOGGER.debug("Cache saved for world {}", (Object)world.dimension().location());
        }
    }

    public static void prefill(ServerLevel world, int minX, int minZ, int maxX, int maxZ) {
        int step = 4;
        CacheStorage storage = CacheManager.state(world);
        AsyncExecutor.execute(() -> {
            ChunkGenerator gen = world.getChunkSource().getGenerator();
            RandomState cfg = world.getChunkSource().randomState();
            Climate.Sampler sampler = cfg.sampler();
            BiomeSource bsrc = gen.getBiomeSource();
            for (int x = minX; x <= maxX; x += step) {
                for (int z = minZ; z <= maxZ; z += step) {
                    long key = CacheManager.hash(x, z);
                    int finalX = x;
                    int finalZ = z;
                    AsyncExecutor.execute(() -> {
                        int h = gen.getBaseHeight(finalX, finalZ, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)world, cfg);
                        Holder biome = bsrc.getNoiseBiome(QuartPos.fromBlock((int)finalX), 316, QuartPos.fromBlock((int)finalZ), sampler);
                        storage.heights().put(key, h);
                        storage.biomes().put(key, (Holder<Biome>)biome);
                    });
                }
            }
            LOGGER.debug("Prefill complete [{}..{}]\u00d7[{}..{}]", new Object[]{minX, maxX, minZ, maxZ});
        });
    }

    public static int getHeight(ServerLevel world, long key, IntSupplier loader) {
        return CacheManager.state(world).heights().computeIfAbsent(key, k -> loader.getAsInt());
    }

    public static int getHeight(ServerLevel world, int x, int z) {
        ChunkGenerator gen = world.getChunkSource().getGenerator();
        RandomState cfg = world.getChunkSource().randomState();
        long key = CacheManager.hash(x, z);
        return CacheManager.getHeight(world, key, () -> gen.getBaseHeight(x, z, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)world, cfg));
    }

    public static double getStability(ServerLevel world, long key, DoubleSupplier loader) {
        return CacheManager.state(world).stabilities().computeIfAbsent(key, k -> loader.getAsDouble());
    }

    public static Holder<Biome> getBiome(ServerLevel world, long key, Supplier<Holder<Biome>> loader) {
        return CacheManager.state(world).biomes().computeIfAbsent(key, k -> (Holder)loader.get());
    }

    public static long hash(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static BlockPos keyToPos(long k) {
        return new BlockPos((int)(k >> 32), 0, (int)k);
    }
}

