/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.worldgen.style.decoration;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.oxcodsnet.roadarchitect.worldgen.style.decoration.Decoration;

public final class FenceDecoration
implements Decoration {
    private static final int MAX_SUPPORT_DEPTH = 3;
    private final BlockState fenceState;

    public FenceDecoration(BlockState fenceState) {
        this.fenceState = fenceState;
    }

    @Override
    public void place(WorldGenLevel world, BlockPos basePos, RandomSource random) {
        BlockPos top = basePos.above();
        int worldTop = world.getMinBuildHeight() + world.getHeight() - 1;
        while (!world.isEmptyBlock(top) && top.getY() < worldTop) {
            top = top.above();
        }
        if (!world.isEmptyBlock(top)) {
            return;
        }
        int depth = 0;
        BlockPos probe = top.below();
        while (probe.getY() >= world.getMinBuildHeight() && !world.getBlockState(probe).isRedstoneConductor((BlockGetter)world, probe)) {
            if (++depth > 3) {
                return;
            }
            probe = probe.below();
        }
        this.setFenceSmart(world, top);
        BlockPos current = top.below();
        while (current.getY() >= world.getMinBuildHeight() && !world.getBlockState(current).isRedstoneConductor((BlockGetter)world, current)) {
            this.setFenceSmart(world, current);
            current = current.below();
        }
    }

    private void setFenceSmart(WorldGenLevel world, BlockPos pos) {
        BlockPos head = pos;
        for (int i = 0; i < 3 && !world.getBlockState(head).canBeReplaced(); ++i) {
            head = head.above();
        }
        if (!world.getBlockState(head).canBeReplaced()) {
            return;
        }
        world.setBlock(head, this.fenceState, 4);
        BlockPos leg = head.below();
        int i = 0;
        while (i < 3 && world.getBlockState(leg).canBeReplaced()) {
            world.setBlock(leg, this.fenceState, 4);
            ++i;
            leg = leg.below();
        }
    }

    public void placeFenceStripe(WorldGenLevel world, List<BlockPos> stripe) {
        for (BlockPos p : stripe) {
            this.setFenceSmart(world, p);
        }
        for (BlockPos p : stripe) {
            BlockState st = world.getBlockState(p);
            for (Direction d : Direction.Plane.HORIZONTAL) {
                BlockPos n = p.relative(d);
                st = st.updateShape(d, world.getBlockState(n), (LevelAccessor)world, p, n);
            }
            world.setBlock(p, st, 4);
        }
    }
}

