/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.forge.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.oxcodsnet.roadarchitect.api.addon.RoadAddons;
import net.oxcodsnet.roadarchitect.handlers.RoadPipelineController;
import net.oxcodsnet.roadarchitect.util.DebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RoadPipelineForgeEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect/ForgeEvents");
    private static boolean dhPresent;

    private RoadPipelineForgeEvents() {
    }

    public static void register() {
        RoadPipelineController.init();
        dhPresent = ModList.get().isLoaded("distanthorizons");
        if (dhPresent) {
            DebugLog.info(LOGGER, "Distant Horizons detected: skipping INIT pregen; pipeline will start on player join", new Object[0]);
        }
        MinecraftForge.EVENT_BUS.register(RoadPipelineForgeEvents.class);
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)levelAccessor;
        if (!(event.getChunk() instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)event.getChunk();
        if (!event.isNewChunk()) {
            return;
        }
        if (!dhPresent) {
            RoadPipelineController.onSpawnChunkGenerated(world, (ChunkAccess)chunk);
        }
        RoadPipelineController.onChunkGenerated(world, (ChunkAccess)chunk);
        RoadAddons.onChunkLoad(world, chunk.m_7697_());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            RoadPipelineController.onPlayerJoin(player2);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        RoadPipelineController.onServerTick(event.getServer());
        RoadAddons.onServerTick(event.getServer());
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        RoadPipelineController.onServerStopping();
    }
}

