/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.KeyUtil;
import net.oxcodsnet.roadarchitect.util.NbtUtils;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathStorage
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)("roadarchitect/" + PathStorage.class.getSimpleName()));
    private static final String KEY = "road_paths";
    private static final String PATHS_KEY = "paths";
    private static final String FROM_KEY = "from";
    private static final String TO_KEY = "to";
    private static final String POS_KEY = "pos";
    private static final String STATUS_KEY = "status";
    private final Map<String, List<BlockPos>> paths = new ConcurrentHashMap<String, List<BlockPos>>();
    private final Map<String, Status> statuses = new ConcurrentHashMap<String, Status>();

    public static PathStorage get(ServerLevel world) {
        return PersistentStateUtil.get(world, PathStorage::new, PathStorage::fromNbt, KEY);
    }

    public static PathStorage fromNbt(CompoundTag tag) {
        PathStorage storage = new PathStorage();
        ListTag list = tag.m_128437_(PATHS_KEY, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            String from = entry.m_128461_(FROM_KEY);
            String to = entry.m_128461_(TO_KEY);
            String key = KeyUtil.pathKey(from, to);
            ListTag posList = entry.m_128437_(POS_KEY, 4);
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (Tag nbtElement : posList) {
                positions.add(BlockPos.m_122022_((long)((LongTag)nbtElement).m_7046_()));
            }
            storage.paths.put(key, positions);
            Status status = NbtUtils.getEnumOrDefault(entry, STATUS_KEY, Status.class, Status.READY);
            storage.statuses.put(key, status);
        }
        return storage;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<String, List<BlockPos>> entry : this.paths.entrySet()) {
            String[] ids = KeyUtil.parsePathKey(entry.getKey());
            if (ids.length != 2) continue;
            CompoundTag elem = new CompoundTag();
            elem.m_128359_(FROM_KEY, ids[0]);
            elem.m_128359_(TO_KEY, ids[1]);
            ListTag posList = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                posList.add((Object)LongTag.m_128882_((long)pos.m_121878_()));
            }
            elem.m_128365_(POS_KEY, (Tag)posList);
            Status st = this.statuses.getOrDefault(entry.getKey(), Status.PENDING);
            elem.m_128359_(STATUS_KEY, st.name());
            list.add((Object)elem);
        }
        tag.m_128365_(PATHS_KEY, (Tag)list);
        return tag;
    }

    public void putPath(String from, String to, List<BlockPos> path, Status status) {
        String key = KeyUtil.pathKey(from, to);
        this.paths.put(key, List.copyOf(path));
        this.statuses.put(key, status);
        this.m_77762_();
    }

    public void updatePath(String key, List<BlockPos> path, Status status) {
        this.paths.put(key, List.copyOf(path));
        this.statuses.put(key, status);
        this.m_77762_();
    }

    public List<BlockPos> getPath(String from, String to) {
        return this.paths.getOrDefault(KeyUtil.pathKey(from, to), List.of());
    }

    public List<BlockPos> getPath(String key) {
        return this.paths.getOrDefault(key, List.of());
    }

    public Status getStatus(String key) {
        return this.statuses.getOrDefault(key, Status.PENDING);
    }

    public void setStatus(String key, Status status) {
        this.statuses.put(key, status);
        this.m_77762_();
    }

    public Map<String, Status> allStatuses() {
        return Map.copyOf(this.statuses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryMarkProcessing(String key) {
        Map<String, Status> map = this.statuses;
        synchronized (map) {
            Status cur = this.statuses.get(key);
            if (cur != Status.PENDING) {
                return false;
            }
            this.statuses.put(key, Status.PROCESSING);
            this.m_77762_();
            return true;
        }
    }

    public List<String> getPendingForChunk(ChunkPos chunk) {
        ArrayList<String> out = new ArrayList<String>();
        block0: for (Map.Entry<String, List<BlockPos>> e : this.paths.entrySet()) {
            if (this.getStatus(e.getKey()) != Status.PENDING) continue;
            for (BlockPos p : e.getValue()) {
                if (!new ChunkPos(p).equals((Object)chunk)) continue;
                out.add(e.getKey());
                continue block0;
            }
        }
        return out;
    }

    public static enum Status {
        PENDING,
        PROCESSING,
        READY,
        FAILED;

    }
}

