/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.oxcodsnet.roadarchitect.storage.components.Node;

public class NodeStorage {
    private final Map<String, Node> nodes = new ConcurrentHashMap<String, Node>();

    public static NodeStorage fromNbt(class_2499 list) {
        NodeStorage storage = new NodeStorage();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 tag = list.method_10602(i);
            String id = tag.method_10558("id");
            class_2338 pos = class_2338.method_10092((long)tag.method_10537("pos"));
            String type = tag.method_10558("type");
            storage.nodes.put(id, new Node(id, pos, type));
        }
        return storage;
    }

    public Node add(class_2338 pos, String type) {
        String id = UUID.randomUUID().toString();
        Node node = new Node(id, pos, type);
        this.nodes.put(id, node);
        return node;
    }

    public boolean remove(String id) {
        return this.nodes.remove(id) != null;
    }

    public Map<String, Node> all() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public void clear() {
        this.nodes.clear();
    }

    public class_2499 toNbt() {
        class_2499 list = new class_2499();
        for (Node node : this.nodes.values()) {
            class_2487 tag = new class_2487();
            tag.method_10582("id", node.id());
            tag.method_10544("pos", node.pos().method_10063());
            tag.method_10582("type", node.type());
            list.add((Object)tag);
        }
        return list;
    }
}

