/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge.client.hook;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.oxcodsnet.roadarchitect.RoadArchitect;
import net.oxcodsnet.roadarchitect.client.gui.RoadGraphDebugScreenVanilla;
import net.oxcodsnet.roadarchitect.neoforge.client.RAKeybinds;
import net.oxcodsnet.roadarchitect.storage.EdgeStorage;
import net.oxcodsnet.roadarchitect.storage.RoadGraphState;
import net.oxcodsnet.roadarchitect.storage.components.Node;

@EventBusSubscriber(modid="roadarchitect", value={Dist.CLIENT})
public final class DebugGraphScreenHook {
    @SubscribeEvent
    public static void onKey(InputEvent.Key e) {
        if (RAKeybinds.OPEN != null && RAKeybinds.OPEN.consumeClick()) {
            ServerLevel world;
            Minecraft mc = Minecraft.getInstance();
            if (mc.screen instanceof RoadGraphDebugScreenVanilla) {
                mc.setScreen(null);
                return;
            }
            ServerLevel serverLevel = world = mc.getSingleplayerServer() == null ? null : mc.getSingleplayerServer().overworld();
            if (world == null) {
                return;
            }
            RoadGraphState state = RoadGraphState.get(world, RoadArchitect.CONFIG.maxConnectionDistance());
            ArrayList<Node> nodes = new ArrayList<Node>(state.nodes().all().values());
            Collection<EdgeStorage.Edge> edges = state.edges().all().values();
            mc.setScreen((Screen)new RoadGraphDebugScreenVanilla(nodes, edges));
        }
    }
}

