/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.JsonCodecProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.oxcodsnet.roadarchitect.worldgen.RoadFeatureRegistry;

public final class RoadBiomeModifierProvider
extends JsonCodecProvider<BiomeModifier> {
    private final CompletableFuture<HolderLookup.Provider> registries;

    public RoadBiomeModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper helper) {
        super(output, PackOutput.Target.DATA_PACK, "roadarchitect", PackType.SERVER_DATA, BiomeModifier.DIRECT_CODEC, registries, "neoforge/biome_modifier", helper);
        this.registries = registries;
    }

    protected void gather() {
        HolderLookup.Provider lookup = this.registries.join();
        HolderSet.Named overworldBiomes = lookup.lookupOrThrow(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderSet.Direct featureSet = HolderSet.direct((Holder[])new Holder[]{lookup.lookupOrThrow(Registries.PLACED_FEATURE).getOrThrow(RoadFeatureRegistry.ROAD_PLACED_FEATURE_KEY)});
        BiomeModifiers.AddFeaturesBiomeModifier modifier = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldBiomes, (HolderSet)featureSet, GenerationStep.Decoration.LOCAL_MODIFICATIONS);
        this.unconditional(ResourceLocation.fromNamespaceAndPath((String)"roadarchitect", (String)"add_road_feature"), modifier);
    }

    public String getName() {
        return "Road Architect Biome Modifiers";
    }
}

