/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.neoforge.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.oxcodsnet.roadarchitect.handlers.RoadPipelineController;

public final class RoadPipelineNeoForgeEvents {
    private RoadPipelineNeoForgeEvents() {
    }

    public static void register() {
        RoadPipelineController.init();
        NeoForge.EVENT_BUS.register(RoadPipelineNeoForgeEvents.class);
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!event.isNewChunk()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)levelAccessor;
        ChunkAccess chunk = event.getChunk();
        RoadPipelineController.onSpawnChunkGenerated(world, chunk);
        RoadPipelineController.onChunkGenerated(world, chunk);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        RoadPipelineController.onPlayerJoin(player2);
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        RoadPipelineController.onServerTick(event.getServer());
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        RoadPipelineController.onServerStopping();
    }
}

