/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadarchitect.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.oxcodsnet.roadarchitect.util.PersistentStateUtil;

public class CacheStorage
extends SavedData {
    private static final String KEY = "road_cache";
    private static final String HEIGHTS_KEY = "heights";
    private static final String STABILITIES_KEY = "stabilities";
    private static final String BIOMES_KEY = "biomes";
    private static final String ENTRY_KEY = "k";
    private static final String ENTRY_VALUE = "v";
    public static final SavedData.Factory<CacheStorage> TYPE = new SavedData.Factory(CacheStorage::new, CacheStorage::fromNbt, DataFixTypes.SAVED_DATA_SCOREBOARD);
    private final ConcurrentMap<Long, Integer> heights = new ConcurrentHashMap<Long, Integer>();
    private final ConcurrentMap<Long, Double> stabilities = new ConcurrentHashMap<Long, Double>();
    private final ConcurrentMap<Long, Holder<Biome>> biomes = new ConcurrentHashMap<Long, Holder<Biome>>();

    public static CacheStorage get(ServerLevel world) {
        return PersistentStateUtil.get(world, TYPE, KEY);
    }

    public static CacheStorage fromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        CacheStorage storage = new CacheStorage();
        ListTag hList = tag.getList(HEIGHTS_KEY, 10);
        for (int i = 0; i < hList.size(); ++i) {
            CompoundTag entry = hList.getCompound(i);
            storage.heights.put(entry.getLong(ENTRY_KEY), entry.getInt(ENTRY_VALUE));
        }
        ListTag sList = tag.getList(STABILITIES_KEY, 10);
        for (int i = 0; i < sList.size(); ++i) {
            CompoundTag entry = sList.getCompound(i);
            storage.stabilities.put(entry.getLong(ENTRY_KEY), entry.getDouble(ENTRY_VALUE));
        }
        ListTag bList = tag.getList(BIOMES_KEY, 10);
        HolderLookup.RegistryLookup registry = lookup.lookupOrThrow(Registries.BIOME);
        for (int i = 0; i < bList.size(); ++i) {
            CompoundTag entry = bList.getCompound(i);
            ResourceLocation id = ResourceLocation.tryParse((String)entry.getString(ENTRY_VALUE));
            if (id == null) continue;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id);
            registry.get(key).ifPresent(e -> storage.biomes.put(entry.getLong(ENTRY_KEY), (Holder<Biome>)e));
        }
        return storage;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider lookup) {
        ListTag hList = new ListTag();
        for (Map.Entry entry : this.heights.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putLong(ENTRY_KEY, ((Long)entry.getKey()).longValue());
            compoundTag.putInt(ENTRY_VALUE, ((Integer)entry.getValue()).intValue());
            hList.add((Object)compoundTag);
        }
        tag.put(HEIGHTS_KEY, (Tag)hList);
        ListTag sList = new ListTag();
        for (Map.Entry entry : this.stabilities.entrySet()) {
            CompoundTag elem = new CompoundTag();
            elem.putLong(ENTRY_KEY, ((Long)entry.getKey()).longValue());
            elem.putDouble(ENTRY_VALUE, ((Double)entry.getValue()).doubleValue());
            sList.add((Object)elem);
        }
        tag.put(STABILITIES_KEY, (Tag)sList);
        ListTag listTag = new ListTag();
        for (Map.Entry entry : this.biomes.entrySet()) {
            ResourceLocation id = ((Holder)entry.getValue()).unwrapKey().map(ResourceKey::location).orElse(null);
            if (id == null) continue;
            CompoundTag elem = new CompoundTag();
            elem.putLong(ENTRY_KEY, ((Long)entry.getKey()).longValue());
            elem.putString(ENTRY_VALUE, id.toString());
            listTag.add((Object)elem);
        }
        tag.put(BIOMES_KEY, (Tag)listTag);
        return tag;
    }

    public ConcurrentMap<Long, Integer> heights() {
        return this.heights;
    }

    public ConcurrentMap<Long, Double> stabilities() {
        return this.stabilities;
    }

    public ConcurrentMap<Long, Holder<Biome>> biomes() {
        return this.biomes;
    }
}

